/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.hg.executer;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.Constants;
import com.upay.sdk.HttpClientUtils;
import com.upay.sdk.exception.ResponseException;
import com.upay.sdk.exception.UnknownException;
import com.upay.sdk.executer.Executer;
import com.upay.sdk.executer.ResultListener;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HgMemberExecuter
extends Executer {
    static final Logger LOGGER = LoggerFactory.getLogger(HgMemberExecuter.class);
    static final String[] ORDER_RESPONSE_HMAC_FIELDS = new String[]{Constants.MERCHANT_ID, "memberId", "userName", Constants.STATUS};
    static final Object[] QUERY_RESPONSE_HMAC_FIELDS = new Object[]{Constants.MERCHANT_ID, "memberId", "mobile", "email", "realname", "idNum", "userType", "bindPayment"};

    public void create(JSONObject requestData, ResultListener resultListener) {
        block4: {
            try {
                LOGGER.debug("requestData:[" + requestData.toJSONString() + "]");
                String responseStr = HttpClientUtils.post(ConfigurationUtils.getHgMemberUrl(), requestData.toJSONString());
                LOGGER.debug("responseStr:[" + responseStr + "]");
                JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
                this.verifyHmac(ORDER_RESPONSE_HMAC_FIELDS, responseData);
                if (Constants.REDIRECT.equals(responseData.getString(Constants.STATUS))) {
                    resultListener.redirect(responseData, responseData.getString("redirectUrl"));
                    break block4;
                }
                if (Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
                    resultListener.success(responseData);
                    break block4;
                }
                throw new ResponseException(responseData);
            }
            catch (IOException e) {
                LOGGER.error("request order exception", (Throwable)e);
                throw new UnknownException(e);
            }
        }
    }

    public void callback(JSONObject responseData, ResultListener listener) {
        this.verifyHmac(QUERY_RESPONSE_HMAC_FIELDS, responseData);
        listener.success(responseData);
    }

    public void query(JSONObject requestData, ResultListener listener) {
        LOGGER.debug("requestData:[" + requestData.toJSONString() + "]");
        String responseStr = HttpClientUtils.post(ConfigurationUtils.getHgMemberQueryUrl(), requestData.toJSONString());
        LOGGER.debug("responseStr:[" + responseStr + "]");
        JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
        this.callback(responseData, listener);
    }
}

