/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.hg.builder;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import org.apache.commons.lang3.StringUtils;

public final class MemberBuilder
extends BuilderSupport {
    private String merchantId;
    private String mobile;
    private String email;
    private String realname;
    private String idNum;
    private String userType;
    private String bindPayment;
    private String accountType;
    private String customerId;
    private String accountHolder;
    private String merchantName;
    private String webSite;
    private String icp;
    private String papers;

    public MemberBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public MemberBuilder setMerchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    public MemberBuilder setMobile(String mobile) {
        this.mobile = mobile;
        return this;
    }

    public MemberBuilder setEmail(String email) {
        this.email = email;
        return this;
    }

    public MemberBuilder setRealname(String realname) {
        this.realname = realname;
        return this;
    }

    public MemberBuilder setIdNum(String idNum) {
        this.idNum = idNum;
        return this;
    }

    public MemberBuilder setUserType(String userType) {
        this.userType = userType;
        return this;
    }

    public MemberBuilder setBindPayment(String bindPayment) {
        this.bindPayment = bindPayment;
        return this;
    }

    public MemberBuilder setAccountType(String accountType) {
        this.accountType = accountType;
        return this;
    }

    public MemberBuilder setCustomerId(String customerId) {
        this.customerId = customerId;
        return this;
    }

    public MemberBuilder setAccountHolder(String accountHolder) {
        this.accountHolder = accountHolder;
        return this;
    }

    public MemberBuilder setIcp(String icp) {
        this.icp = icp;
        return this;
    }

    public MemberBuilder setWebSite(String webSite) {
        this.webSite = webSite;
        return this;
    }

    public MemberBuilder setPapers(String papers) {
        this.papers = papers;
        return this;
    }

    public MemberBuilder setMerchantName(String merchantName) {
        this.merchantName = merchantName;
        return this;
    }

    public JSONObject build() {
        JSONObject json = super.build(this.merchantId);
        if (StringUtils.isNotBlank((CharSequence)this.mobile)) {
            json.put("mobile", (Object)this.mobile);
        }
        if (StringUtils.isNotBlank((CharSequence)this.email)) {
            json.put("email", (Object)this.email);
        }
        if (StringUtils.isNotBlank((CharSequence)this.realname)) {
            json.put("realname", (Object)this.realname);
        }
        if (StringUtils.isNotBlank((CharSequence)this.idNum)) {
            json.put("idNum", (Object)this.idNum);
        }
        if (StringUtils.isNotBlank((CharSequence)this.userType)) {
            json.put("userType", (Object)this.userType);
        }
        if (StringUtils.isNotBlank((CharSequence)this.bindPayment)) {
            json.put("bindPayment", (Object)this.bindPayment);
        }
        if (StringUtils.isNotBlank((CharSequence)this.accountType)) {
            json.put("accountType", (Object)this.accountType);
        }
        if (StringUtils.isNotBlank((CharSequence)this.customerId)) {
            json.put("customerId", (Object)this.customerId);
        }
        if (StringUtils.isNotBlank((CharSequence)this.accountHolder)) {
            json.put("accountHolder", (Object)this.accountHolder);
        }
        if (StringUtils.isNotBlank((CharSequence)this.merchantName)) {
            json.put("merchantName", (Object)this.merchantName);
        }
        if (StringUtils.isNotBlank((CharSequence)this.webSite)) {
            json.put("webSite", (Object)this.webSite);
        }
        if (StringUtils.isNotBlank((CharSequence)this.icp)) {
            json.put("icp", (Object)this.icp);
        }
        if (StringUtils.isNotBlank((CharSequence)this.papers)) {
            json.put("papers", (Object)this.papers);
        }
        json.put("hmac", (Object)this.generateHmac());
        return json;
    }

    private String generateHmac() {
        StringBuilder hmacSource = new StringBuilder();
        hmacSource.append(StringUtils.defaultString((String)this.merchantId)).append(StringUtils.defaultString((String)this.mobile, (String)"")).append(StringUtils.defaultString((String)this.email, (String)"")).append(StringUtils.defaultString((String)this.realname, (String)"")).append(StringUtils.defaultString((String)this.idNum, (String)"")).append(StringUtils.defaultString((String)this.userType, (String)"")).append(StringUtils.defaultString((String)this.bindPayment, (String)""));
        if (StringUtils.isNotBlank((CharSequence)this.accountType)) {
            hmacSource.append(StringUtils.defaultString((String)this.accountType, (String)""));
        }
        if (StringUtils.isNotBlank((CharSequence)this.customerId)) {
            hmacSource.append(StringUtils.defaultString((String)this.customerId, (String)""));
        }
        if (StringUtils.isNotBlank((CharSequence)this.accountHolder)) {
            hmacSource.append(StringUtils.defaultString((String)this.accountHolder, (String)""));
        }
        if (StringUtils.isNotBlank((CharSequence)this.merchantName)) {
            hmacSource.append(StringUtils.defaultString((String)this.merchantName, (String)""));
        }
        if (StringUtils.isNotBlank((CharSequence)this.webSite)) {
            hmacSource.append(StringUtils.defaultString((String)this.webSite, (String)""));
        }
        if (StringUtils.isNotBlank((CharSequence)this.icp)) {
            hmacSource.append(StringUtils.defaultString((String)this.icp, (String)""));
        }
        if (StringUtils.isNotBlank((CharSequence)this.papers)) {
            hmacSource.append(StringUtils.defaultString((String)this.papers, (String)""));
        }
        return SignUtils.signMd5(hmacSource.toString(), ConfigurationUtils.getHmacKey(this.merchantId));
    }
}

