/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.hg.builder;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import org.apache.commons.lang3.StringUtils;

public final class HgTransferOrderBuilder
extends BuilderSupport {
    private String requestId;
    private String merchantId;
    private String fromMember;
    private String toMember;
    private String amount;
    private String currency;

    public HgTransferOrderBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public HgTransferOrderBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public HgTransferOrderBuilder setFromMember(String fromMember) {
        this.fromMember = fromMember;
        return this;
    }

    public HgTransferOrderBuilder setToMember(String toMember) {
        this.toMember = toMember;
        return this;
    }

    public HgTransferOrderBuilder setAmount(String amount) {
        this.amount = amount;
        return this;
    }

    public HgTransferOrderBuilder setCurrency(String currency) {
        this.currency = currency;
        return this;
    }

    public JSONObject build() {
        JSONObject json = super.build(this.merchantId);
        if (StringUtils.isNotBlank((CharSequence)this.requestId)) {
            json.put("requestId", (Object)this.requestId);
        }
        if (StringUtils.isNotBlank((CharSequence)this.fromMember)) {
            json.put("fromMember", (Object)this.fromMember);
        }
        if (StringUtils.isNotBlank((CharSequence)this.toMember)) {
            json.put("toMember", (Object)this.toMember);
        }
        if (StringUtils.isNotBlank((CharSequence)this.amount)) {
            json.put("amount", (Object)this.amount);
        }
        if (StringUtils.isNotBlank((CharSequence)this.currency)) {
            json.put("currency", (Object)this.currency);
        }
        json.put("hmac", (Object)this.generateHmac());
        return json;
    }

    private String generateHmac() {
        StringBuilder hmacSource = new StringBuilder();
        hmacSource.append(StringUtils.defaultString((String)this.merchantId)).append(StringUtils.defaultString((String)this.requestId)).append(StringUtils.defaultString((String)this.fromMember, (String)"")).append(StringUtils.defaultString((String)this.toMember, (String)"")).append(StringUtils.defaultString((String)this.amount, (String)"")).append(StringUtils.defaultString((String)this.currency, (String)""));
        System.out.println("===========" + hmacSource.toString());
        return SignUtils.signMd5(hmacSource.toString(), ConfigurationUtils.getHmacKey(this.merchantId));
    }
}

