/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.foreignpayExchangesettlement.builder;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryBuilder
extends BuilderSupport {
    static final Logger LOGGER = LoggerFactory.getLogger(QueryBuilder.class);
    private String requestId;
    private String merchantId;

    public QueryBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public QueryBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public JSONObject buildRequestData() {
        JSONObject json = super.build(this.merchantId);
        if (StringUtils.isNotBlank((CharSequence)this.requestId)) {
            json.put("requestId", (Object)this.requestId);
        }
        if (StringUtils.isNotBlank((CharSequence)this.merchantId)) {
            json.put("merchantId", (Object)this.merchantId);
        }
        json.put("hmac", (Object)this.generateHmac());
        return json;
    }

    public String generateHmac() {
        StringBuilder requestBuilder = new StringBuilder();
        requestBuilder.append(StringUtils.defaultString((String)this.merchantId)).append(StringUtils.defaultString((String)this.requestId));
        String hmacKey = ConfigurationUtils.getHmacKey(this.merchantId);
        LOGGER.info("QueryBuilder generateHmac requestBuilder:{},hmacKey:{}", (Object)requestBuilder.toString(), (Object)hmacKey);
        return SignUtils.signMd5(requestBuilder.toString(), hmacKey);
    }
}

