/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.executer;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.Constants;
import com.upay.sdk.SignUtils;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.exception.HmacVerifyException;
import com.upay.sdk.exception.RequestException;
import com.upay.sdk.exception.ResponseException;
import com.upay.sdk.exception.UnknownException;
import com.upay.sdk.executer.HmacArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.lang.IllegalClassException;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Executer {
    static final Logger LOGGER = LoggerFactory.getLogger(Executer.class);
    private final String[] excludeField = new String[]{Constants.HMAC};

    public void verifyHmac(String[] fields, JSONObject json) {
        if (Constants.ERROR.equals(json.getString(Constants.STATUS))) {
            throw new RequestException(json);
        }
        StringBuilder hmacSource = new StringBuilder();
        for (String field : fields) {
            hmacSource.append(ObjectUtils.defaultIfNull((Object)JSONPath.eval((Object)json, (String)field), (Object)""));
        }
        String source = hmacSource.toString();
        String hmac = json.getString("hmac");
        String merchantId = json.getString(Constants.MERCHANT_ID);
        LOGGER.info("json : {}", (Object)json.toJSONString());
        String sourceHmac = SignUtils.signMd5(source, ConfigurationUtils.getHmacKey(merchantId));
        if (!sourceHmac.equals(hmac)) {
            throw new HmacVerifyException(source, sourceHmac, hmac);
        }
    }

    public void verifyHmac(Object[] fields, JSONObject json) {
        if (Constants.ERROR.equals(json.getString(Constants.STATUS))) {
            throw new RequestException(json);
        }
        String source = this.getHmacSource(fields, json);
        LOGGER.debug("verifyHmac source:[" + source + "]");
        LOGGER.info("json : {}", (Object)json.toJSONString());
        String hmac = json.getString("hmac");
        String sourceHmac = SignUtils.signMd5(source, ConfigurationUtils.getHmacKey(json.getString(Constants.MERCHANT_ID)));
        if (!sourceHmac.equals(hmac)) {
            throw new HmacVerifyException(source, sourceHmac, hmac);
        }
    }

    public void verifyHmacOrder(Object[] fields, JSONObject json) {
        LOGGER.info("resp json : {}", (Object)json);
        if (Constants.ERROR.equals(json.getString(Constants.STATUS))) {
            throw new RequestException(json);
        }
        Object[] fs = this.sortFields(fields);
        String source = this.getHmacSourceSort(fs, json);
        LOGGER.info("verifyHmacOrder source : {}", (Object)source);
        LOGGER.info("json : {}", (Object)json.toJSONString());
        String hmac = json.getString("hmac");
        String sourceHmac = SignUtils.signMd5(source, ConfigurationUtils.getHmacKey(json.getString(Constants.MERCHANT_ID)));
        if (!sourceHmac.equals(hmac)) {
            throw new HmacVerifyException(source, sourceHmac, hmac);
        }
    }

    public void verifyHmacOrder(JSONObject json) {
        LOGGER.info("resp json : {}", (Object)json);
        if (json == null || Constants.ERROR.equals(json.getString(Constants.STATUS))) {
            throw new RequestException(json);
        }
        if (StringUtils.isNotEmpty((CharSequence)json.getString("httpStatus"))) {
            int httpStatus = Integer.parseInt(json.getString("httpStatus"));
            LOGGER.info("HttpStatus[" + httpStatus + "]");
            if (httpStatus == 406) {
                json.put("errorMessage", (Object)"Data error, Access denied. Http status is 406 !");
                throw new ResponseException(json);
            }
        }
        StringBuilder hmacSource = new StringBuilder();
        this.appendKeys(json, hmacSource);
        String source = hmacSource.toString();
        LOGGER.info("verifyHmacOrder source : {}", (Object)source);
        LOGGER.info("json : {}", (Object)json.toJSONString());
        String hmac = json.getString("hmac");
        String hmacKey = ConfigurationUtils.getHmacKey(json.getString(Constants.MERCHANT_ID));
        String sourceHmac = SignUtils.signMd5(source, hmacKey);
        if (!sourceHmac.equals(hmac)) {
            LOGGER.debug("verifyHmacOrder invalid sourceHmac : [{}],hmac:[{}]", (Object)sourceHmac, (Object)hmac);
            throw new HmacVerifyException(source, sourceHmac, hmac);
        }
        LOGGER.debug("verifyHmacOrder pass sourceHmac : [{}],hmac:[{}]", (Object)sourceHmac, (Object)hmac);
    }

    public void bothVerifyHmacOrder(JSONObject json) {
        LOGGER.info("resp json : {}", (Object)json);
        if (json == null || Constants.ERROR.equals(json.getString(Constants.STATUS))) {
            throw new RequestException(json);
        }
        if (StringUtils.isNotEmpty((CharSequence)json.getString("httpStatus"))) {
            int httpStatus = Integer.parseInt(json.getString("httpStatus"));
            LOGGER.info("HttpStatus[" + httpStatus + "]");
            if (httpStatus == 406) {
                json.put("errorMessage", (Object)"Data error, Access denied. Http status is 406 !");
                throw new ResponseException(json);
            }
        }
        StringBuilder hmacSource = new StringBuilder();
        this.appendKeys(json, hmacSource);
        String source = hmacSource.toString();
        LOGGER.info("bothVerifyHmacOrder source : {}", (Object)source);
        LOGGER.debug("json : {}", (Object)json.toJSONString());
        String hmac = json.getString(Constants.HMAC);
        try {
            boolean verify = CipherWrapper.signAndVerify(json.getString(Constants.MERCHANT_ID), json.getString(Constants.PARTNER_ID), source, hmac);
            if (!verify) {
                LOGGER.debug("verifyHmacOrder sign invalid ");
                throw new HmacVerifyException(source, "", hmac);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UnknownException(e);
        }
    }

    private void appendKeys(JSONObject json, StringBuilder hmacSource) {
        Set keys = json.keySet();
        ArrayList list = new ArrayList(keys);
        Collections.sort(list);
        for (String key : list) {
            boolean exclude = false;
            for (String field : this.excludeField) {
                if (!key.equals(field)) continue;
                exclude = true;
                break;
            }
            if (exclude) continue;
            Object obj = json.get((Object)key);
            if (obj == null) {
                LOGGER.warn("value is null for key:[{}],json:[{}]", (Object)key, (Object)json.toJSONString());
                continue;
            }
            if (obj instanceof JSONObject) {
                this.appendKeys((JSONObject)obj, hmacSource);
                continue;
            }
            if (obj instanceof JSONArray) {
                JSONArray array = (JSONArray)obj;
                for (Object o : array) {
                    this.appendKeys((JSONObject)o, hmacSource);
                }
                continue;
            }
            if (!StringUtils.isNotBlank((CharSequence)obj.toString())) continue;
            hmacSource.append(obj).append("#");
        }
    }

    private Object[] sortFields(Object[] fields) {
        Object[] fs = new Object[fields.length];
        System.arraycopy(fields, 0, fs, 0, fields.length);
        Arrays.sort(fs);
        return fs;
    }

    private String getHmacSource(Object[] fields, JSONObject json) {
        StringBuilder hmacSource = new StringBuilder();
        for (Object field : fields) {
            if (field instanceof String) {
                hmacSource.append(ObjectUtils.defaultIfNull((Object)JSONPath.eval((Object)json, (String)((String)field)), (Object)""));
                continue;
            }
            if (field instanceof HmacArray) {
                HmacArray ha = (HmacArray)field;
                JSONArray jsons = json.getJSONArray(ha.getKey());
                if (jsons == null) continue;
                for (Object o : jsons) {
                    hmacSource.append(this.getHmacSource(ha.getItems(), (JSONObject)o));
                }
                continue;
            }
            throw new IllegalClassException("field class:[" + field.getClass() + "]");
        }
        return hmacSource.toString();
    }

    private String getHmacSourceSort(Object[] fields, JSONObject json) {
        StringBuilder hmacSource = new StringBuilder();
        for (Object field : fields) {
            if (field instanceof String) {
                hmacSource.append(ObjectUtils.defaultIfNull((Object)JSONPath.eval((Object)json, (String)((String)field)), (Object)""));
                continue;
            }
            if (field instanceof HmacArray) {
                HmacArray ha = (HmacArray)field;
                Object[] items = this.sortFields(ha.getItems());
                JSONArray jsons = json.getJSONArray(ha.getKey());
                if (jsons == null) continue;
                for (Object o : jsons) {
                    hmacSource.append(this.getHmacSourceSort(items, (JSONObject)o));
                }
                continue;
            }
            throw new IllegalClassException("field class:[" + field.getClass() + "]");
        }
        return hmacSource.toString();
    }
}

