/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.eshopping.vcc.executer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.Constants;
import com.upay.sdk.HttpClientUtils;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.eshopping.vcc.builder.GetListPriceBuilder;
import com.upay.sdk.exception.ResponseException;
import com.upay.sdk.executer.Executer;
import com.upay.sdk.executer.ResultListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EshoppingGetListPriceExecutor
extends Executer {
    static final Logger LOGGER = LoggerFactory.getLogger(EshoppingGetListPriceExecutor.class);

    public void getListPriceV_3(GetListPriceBuilder builder, ResultListener resultListener) {
        LOGGER.debug("EshoppingGetListPriceExecutor getListPriceV_3 builder:[" + JSON.toJSONString((Object)builder) + "]");
        JSONObject requestData = builder.bothEncryptBuild();
        LOGGER.debug("EshoppingGetListPriceExecutor getListPriceV_3 requestData:[" + requestData.toJSONString() + "]");
        String responseStr = HttpClientUtils.post3(ConfigurationUtils.getEshoppingGetListPriceUrl(), requestData);
        LOGGER.debug("EshoppingGetListPriceExecutor getListPriceV_3 responseStr:[" + responseStr + "]");
        JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
        String status = responseData.getString(Constants.STATUS);
        if (Constants.ERROR.equals(status)) {
            throw new ResponseException(responseData);
        }
        responseData = CipherWrapper.bothDecryptWrap(responseData);
        LOGGER.debug("EshoppingGetListPriceExecutor getListPriceV_3 responseStr:[" + responseData + "]");
        this.bothVerifyHmacOrder(responseData);
        if (!Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
            throw new ResponseException(responseData);
        }
        resultListener.success(responseData);
    }
}

