/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.eshopping.builder;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.entity.PassengerInfo;
import com.upay.sdk.exception.UnknownException;
import java.util.LinkedList;
import java.util.List;

public final class OrderBuilder
extends BuilderSupport {
    private String merchantId;
    private String requestId;
    private String userId;
    private String flightInfoId;
    private String luggageWeight;
    private Boolean isNeedFood;
    private Boolean isNeedInsurance;
    private List<PassengerInfo> passengerInfoList = new LinkedList<PassengerInfo>();

    public OrderBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public OrderBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public JSONObject encryptBuild() {
        JSONObject json = super.assembleBuild();
        json.put("hmac", (Object)this.orderGenerateHmac());
        return CipherWrapper.encryptWrap(this.merchantId, json);
    }

    @Override
    protected String orderGenerateHmac() {
        return SignUtils.signMd5(super.orderGenerateHmac(), ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }

    public String getMerchantId() {
        return this.merchantId;
    }

    public OrderBuilder setMerchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getUserId() {
        return this.userId;
    }

    public OrderBuilder setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public String getFlightInfoId() {
        return this.flightInfoId;
    }

    public OrderBuilder setFlightInfoId(String flightInfoId) {
        this.flightInfoId = flightInfoId;
        return this;
    }

    public String getLuggageWeight() {
        return this.luggageWeight;
    }

    public OrderBuilder setLuggageWeight(String luggageWeight) {
        this.luggageWeight = luggageWeight;
        return this;
    }

    public Boolean getIsNeedFood() {
        return this.isNeedFood;
    }

    public OrderBuilder setIsNeedFood(Boolean isNeedFood) {
        this.isNeedFood = isNeedFood;
        return this;
    }

    public Boolean GetIsNeedInsurance() {
        return this.isNeedInsurance;
    }

    public void setIsNeedInsurance(Boolean isNeedInsurance) {
        this.isNeedInsurance = isNeedInsurance;
    }

    public List<PassengerInfo> getPassengerInfoList() {
        return this.passengerInfoList;
    }

    public void setPassengerInfoList(List<PassengerInfo> passengerInfoList) {
        this.passengerInfoList = passengerInfoList;
    }
}

