/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.ert.v_3.v2.builder;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.exception.UnknownException;
import org.apache.commons.lang3.StringUtils;

public class OrderQueryBuilder
extends BuilderSupport {
    private String merchantId;
    private String requestId;
    private String partnerId;

    public OrderQueryBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public OrderQueryBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public OrderQueryBuilder setPartnerId(String partnerId) {
        this.partnerId = partnerId;
        return this;
    }

    public JSONObject build() {
        JSONObject json = super.build(this.merchantId);
        if (StringUtils.isNotBlank((CharSequence)this.requestId)) {
            json.put("requestId", (Object)this.requestId);
        }
        if (StringUtils.isNotBlank((CharSequence)this.partnerId)) {
            json.put("partnerId", (Object)this.partnerId);
        }
        json.put("hmac", (Object)this.generateHmac());
        return json;
    }

    private String generateHmac() {
        StringBuilder hmacSource = new StringBuilder();
        hmacSource.append(StringUtils.defaultString((String)this.merchantId)).append(StringUtils.defaultString((String)this.requestId)).append(StringUtils.defaultString((String)this.partnerId));
        return SignUtils.signMd5(hmacSource.toString(), ConfigurationUtils.getHmacKey(StringUtils.isBlank((CharSequence)this.partnerId) ? this.merchantId : this.partnerId));
    }

    public JSONObject encryptBuild() {
        JSONObject json = super.assembleBuild();
        json.put("hmac", (Object)this.orderGenerateHmac());
        if (StringUtils.isNotBlank((CharSequence)this.partnerId)) {
            return CipherWrapper.bothEncryptWrap(this.merchantId, this.partnerId, json);
        }
        return CipherWrapper.encryptWrap(this.merchantId, json);
    }

    @Override
    protected String orderGenerateHmac() {
        return SignUtils.signMd5(super.orderGenerateHmac(), ConfigurationUtils.getHmacKey(StringUtils.isBlank((CharSequence)this.partnerId) ? this.merchantId : this.partnerId));
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        if (StringUtils.isNotBlank((CharSequence)this.partnerId)) {
            return CipherWrapper.bothEncryptWrap(this.merchantId, this.partnerId, json);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }
}

