/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.ert.v_3.v2.builder;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.exception.UnknownException;

public final class MerchantWechatConfigBuilder
extends BuilderSupport {
    private String merchantId;
    private String bankMerchantId;
    private String reportType;
    private String merchantCode;
    private String configType;
    private String configInfo;
    private String notifyUrl;

    public MerchantWechatConfigBuilder setMerchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    public MerchantWechatConfigBuilder setBankMerchantId(String bankMerchantId) {
        this.bankMerchantId = bankMerchantId;
        return this;
    }

    public MerchantWechatConfigBuilder setReportType(String reportType) {
        this.reportType = reportType;
        return this;
    }

    public MerchantWechatConfigBuilder setMerchantCode(String merchantCode) {
        this.merchantCode = merchantCode;
        return this;
    }

    public MerchantWechatConfigBuilder setConfigType(String configType) {
        this.configType = configType;
        return this;
    }

    public MerchantWechatConfigBuilder setConfigInfo(String configInfo) {
        this.configInfo = configInfo;
        return this;
    }

    public MerchantWechatConfigBuilder setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
        return this;
    }

    @Override
    protected String orderGenerateHmac() {
        return SignUtils.signMd5(super.orderGenerateHmac(), ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }
}

