/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.ert.v_3.v2.builder;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.exception.UnknownException;

public final class MerchantReportBuilder
extends BuilderSupport {
    private String merchantId;
    private String requestId;
    private String bankMerchantId;
    private String signedName;
    private String reportType;
    private String distributorNo;
    private String reportSerialNo;
    private String merShortname;
    private String contactName;
    private String contactEmail;
    private String contactPhone;
    private String contactIdNo;
    private String servicePhone;
    private String notifyUrl;
    private String contactMobilePhone;
    private String contactBusinessType;
    private String contactType;
    private String idCardNo;
    private String accountName;
    private String bankCardNo;
    private String provinceCode;
    private String cityCode;
    private String districtCode;
    private String address;
    private String country;
    private String website;
    private String reportBankCardType;
    private String singleLimitAmount;
    private String singleCardDayAccumulativeLimitAmount;
    private String certificateType;
    private String levelRates;
    private String supportTradingScenarios;
    private String channelType;
    private String belongPassageCode;
    private String remarks;
    private String merchantCerType;
    private String merchantCerNo;
    private String distributorName;
    private String indirectLevel;

    public MerchantReportBuilder setMerchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    public MerchantReportBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public MerchantReportBuilder setSignedName(String signedName) {
        this.signedName = signedName;
        return this;
    }

    public MerchantReportBuilder setBankMerchantId(String bankMerchantId) {
        this.bankMerchantId = bankMerchantId;
        return this;
    }

    public MerchantReportBuilder setReportType(String reportType) {
        this.reportType = reportType;
        return this;
    }

    public MerchantReportBuilder setDistributorNo(String distributorNo) {
        this.distributorNo = distributorNo;
        return this;
    }

    public MerchantReportBuilder setReportSerialNo(String reportSerialNo) {
        this.reportSerialNo = reportSerialNo;
        return this;
    }

    public MerchantReportBuilder setMerShortname(String merShortname) {
        this.merShortname = merShortname;
        return this;
    }

    public MerchantReportBuilder setContactName(String contactName) {
        this.contactName = contactName;
        return this;
    }

    public MerchantReportBuilder setContactEmail(String contactEmail) {
        this.contactEmail = contactEmail;
        return this;
    }

    public MerchantReportBuilder setContactPhone(String contactPhone) {
        this.contactPhone = contactPhone;
        return this;
    }

    public MerchantReportBuilder setContactIdNo(String contactIdNo) {
        this.contactIdNo = contactIdNo;
        return this;
    }

    public MerchantReportBuilder setServicePhone(String servicePhone) {
        this.servicePhone = servicePhone;
        return this;
    }

    public MerchantReportBuilder setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
        return this;
    }

    public MerchantReportBuilder setContactMobilePhone(String contactMobilePhone) {
        this.contactMobilePhone = contactMobilePhone;
        return this;
    }

    public MerchantReportBuilder setContactBusinessType(String contactBusinessType) {
        this.contactBusinessType = contactBusinessType;
        return this;
    }

    public MerchantReportBuilder setContactType(String contactType) {
        this.contactType = contactType;
        return this;
    }

    public MerchantReportBuilder setIdCardNo(String idCardNo) {
        this.idCardNo = idCardNo;
        return this;
    }

    public MerchantReportBuilder setAccountName(String accountName) {
        this.accountName = accountName;
        return this;
    }

    public MerchantReportBuilder setBankCardNo(String bankCardNo) {
        this.bankCardNo = bankCardNo;
        return this;
    }

    public MerchantReportBuilder setProvinceCode(String provinceCode) {
        this.provinceCode = provinceCode;
        return this;
    }

    public MerchantReportBuilder setCityCode(String cityCode) {
        this.cityCode = cityCode;
        return this;
    }

    public MerchantReportBuilder setDistrictCode(String districtCode) {
        this.districtCode = districtCode;
        return this;
    }

    public MerchantReportBuilder setAddress(String address) {
        this.address = address;
        return this;
    }

    public MerchantReportBuilder setCountry(String country) {
        this.country = country;
        return this;
    }

    public MerchantReportBuilder setWebsite(String website) {
        this.website = website;
        return this;
    }

    public MerchantReportBuilder setReportBankCardType(String reportBankCardType) {
        this.reportBankCardType = reportBankCardType;
        return this;
    }

    public MerchantReportBuilder setSingleLimitAmount(String singleLimitAmount) {
        this.singleLimitAmount = singleLimitAmount;
        return this;
    }

    public MerchantReportBuilder setSingleCardDayAccumulativeLimitAmount(String singleCardDayAccumulativeLimitAmount) {
        this.singleCardDayAccumulativeLimitAmount = singleCardDayAccumulativeLimitAmount;
        return this;
    }

    public MerchantReportBuilder setCertificateType(String certificateType) {
        this.certificateType = certificateType;
        return this;
    }

    public MerchantReportBuilder setLevelRates(String levelRates) {
        this.levelRates = levelRates;
        return this;
    }

    public MerchantReportBuilder setSupportTradingScenarios(String supportTradingScenarios) {
        this.supportTradingScenarios = supportTradingScenarios;
        return this;
    }

    public MerchantReportBuilder setChannelType(String channelType) {
        this.channelType = channelType;
        return this;
    }

    public MerchantReportBuilder setBelongPassageCode(String belongPassageCode) {
        this.belongPassageCode = belongPassageCode;
        return this;
    }

    public MerchantReportBuilder setRemarks(String remarks) {
        this.remarks = remarks;
        return this;
    }

    public String getMerchantCerType() {
        return this.merchantCerType;
    }

    public MerchantReportBuilder setMerchantCerType(String merchantCerType) {
        this.merchantCerType = merchantCerType;
        return this;
    }

    public String getMerchantCerNo() {
        return this.merchantCerNo;
    }

    public MerchantReportBuilder setMerchantCerNo(String merchantCerNo) {
        this.merchantCerNo = merchantCerNo;
        return this;
    }

    public String getDistributorName() {
        return this.distributorName;
    }

    public MerchantReportBuilder setDistributorName(String distributorName) {
        this.distributorName = distributorName;
        return this;
    }

    public String getIndirectLevel() {
        return this.indirectLevel;
    }

    public MerchantReportBuilder setIndirectLevel(String indirectLevel) {
        this.indirectLevel = indirectLevel;
        return this;
    }

    @Override
    protected String orderGenerateHmac() {
        return SignUtils.signMd5(super.orderGenerateHmac(), ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }
}

