/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.enjoy.merchant.executer;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.Constants;
import com.upay.sdk.HttpClientUtils;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.core.response.HttpReponse;
import com.upay.sdk.enjoy.merchant.builder.MerchantWithdrawBuilder;
import com.upay.sdk.enjoy.merchant.builder.MerchantWithdrawQueryBuilder;
import com.upay.sdk.exception.RequestParamException;
import com.upay.sdk.exception.ResponseDecryptException;
import com.upay.sdk.exception.ResponseException;
import com.upay.sdk.exception.UnknownException;
import com.upay.sdk.executer.Executer;
import com.upay.sdk.executer.ResultListener;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MerchantWithdrawExecuter
extends Executer {
    private static final Logger LOGGER = LoggerFactory.getLogger(MerchantWithdrawExecuter.class);

    public void create(MerchantWithdrawBuilder builder, ResultListener resultListener) throws RequestParamException, ResponseDecryptException {
        String url = ConfigurationUtils.getEnjoyMerchantWithdrawCreateUrl();
        try {
            HttpReponse response = HttpClientUtils.sdkPost(url, builder);
            Object decryptResponse = response.getDecryptResponse();
            if (!(decryptResponse instanceof JSONObject)) {
                throw new RuntimeException("server response error,response object not a json!");
            }
            JSONObject responseJson = (JSONObject)decryptResponse;
            if (response.success()) {
                String status = responseJson.getString(Constants.STATUS);
                if (StringUtils.isBlank((CharSequence)status) || Constants.SUCCESS.equals(status)) {
                    resultListener.success(responseJson);
                } else {
                    resultListener.failure(responseJson);
                }
            } else {
                LOGGER.error("create request response error,errorCode:{}", (Object)response.getResponseCode());
                resultListener.failure(responseJson);
            }
        }
        catch (RequestParamException e) {
            LOGGER.error("create request url:[{}]", (Object)url, (Object)e);
            throw e;
        }
        catch (ResponseDecryptException e) {
            LOGGER.error("create request url:[{}] ", (Object)url, (Object)e);
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("create request url:[{}]", (Object)url, (Object)e);
            throw new UnknownException(e);
        }
    }

    public void query(MerchantWithdrawQueryBuilder builder, ResultListener resultListener) throws RequestParamException, ResponseDecryptException {
        String url = ConfigurationUtils.getEnjoyMerchantWithdrawQueryUrl();
        try {
            HttpReponse response = HttpClientUtils.sdkPost(url, builder);
            Object decryptResponse = response.getDecryptResponse();
            if (!(decryptResponse instanceof JSONObject)) {
                throw new RuntimeException("server response error,response object not a json!");
            }
            JSONObject responseJson = (JSONObject)decryptResponse;
            if (response.success()) {
                String status = responseJson.getString(Constants.STATUS);
                if (StringUtils.isBlank((CharSequence)status) || Constants.SUCCESS.equals(status)) {
                    resultListener.success(responseJson);
                } else {
                    resultListener.failure(responseJson);
                }
            } else {
                LOGGER.error("query request response error,errorCode:{}", (Object)response.getResponseCode());
                resultListener.failure(responseJson);
            }
        }
        catch (RequestParamException e) {
            LOGGER.error("query request url:[{}]", (Object)url, (Object)e);
            throw e;
        }
        catch (ResponseDecryptException e) {
            LOGGER.error("query request url:[{}] ", (Object)url, (Object)e);
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("query request url:[{}]", (Object)url, (Object)e);
            throw new UnknownException(e);
        }
    }

    public void callback(JSONObject responseData, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        JSONObject data = CipherWrapper.bothDecryptWrap(responseData);
        this.bothVerifyHmacOrder(data);
        String status = data.getString(Constants.STATUS);
        LOGGER.info("status:{}", (Object)status);
        if (StringUtils.isNotBlank((CharSequence)status)) {
            if (Constants.SUCCESS.equals(status)) {
                listener.success(data);
            } else if (Constants.FAILED.equals(status) || Constants.CANCEL.equals(status)) {
                listener.failure(data);
            } else if (Constants.INIT.equals(status)) {
                listener.pending(data);
            } else {
                throw new ResponseException(data);
            }
        }
    }
}

