/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.enjoy.merchant.executer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.Constants;
import com.upay.sdk.HttpClientUtils;
import com.upay.sdk.core.response.HttpReponse;
import com.upay.sdk.enjoy.merchant.builder.MerchantBuilder;
import com.upay.sdk.exception.UnknownException;
import com.upay.sdk.executer.Executer;
import com.upay.sdk.executer.ResultListener;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MerchantExecuter
extends Executer {
    static final Logger LOGGER = LoggerFactory.getLogger(MerchantExecuter.class);

    public void bothCreate(MerchantBuilder builder, ResultListener resultListener) {
        try {
            LOGGER.debug("bothCreate requestData:[" + JSON.toJSONString((Object)builder) + "]");
            HttpReponse httpReponse = HttpClientUtils.sdkPost(ConfigurationUtils.getEnjoyMerchantCreateUrl(), builder);
            LOGGER.info("bothAuth responseStr:[" + httpReponse.getDecryptResponse() + "]");
            Object resObject = httpReponse.getDecryptResponse();
            if (!(resObject instanceof JSONObject)) {
                throw new RuntimeException("server response error,response object not a json!");
            }
            JSONObject responseJson = (JSONObject)resObject;
            if (httpReponse.success()) {
                String status = responseJson.getString(Constants.STATUS);
                if (StringUtils.isBlank((CharSequence)status) || Constants.SUCCESS.equals(status)) {
                    resultListener.success(responseJson);
                } else {
                    resultListener.failure(responseJson);
                }
            } else {
                LOGGER.error("getLoginTicket request response error,errorCode:{}", (Object)httpReponse.getResponseCode());
                resultListener.failure(responseJson);
            }
        }
        catch (Exception e) {
            LOGGER.error("bothAuth error", (Throwable)e);
            throw new UnknownException(e);
        }
    }
}

