/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.enjoy.merchant.executer;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.Constants;
import com.upay.sdk.HttpClientUtils;
import com.upay.sdk.core.response.HttpReponse;
import com.upay.sdk.enjoy.merchant.builder.MerchantBankCardBuilder;
import com.upay.sdk.enjoy.merchant.builder.MerchantBankCardSetDefaultBuilder;
import com.upay.sdk.enjoy.merchant.builder.MerchantBankCardUnbindBuilder;
import com.upay.sdk.exception.RequestParamException;
import com.upay.sdk.exception.ResponseDecryptException;
import com.upay.sdk.exception.UnknownException;
import com.upay.sdk.executer.Executer;
import com.upay.sdk.executer.ResultListener;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MerchantBankCardExecuter
extends Executer {
    private static final Logger LOGGER = LoggerFactory.getLogger(MerchantBankCardExecuter.class);

    public void submit(MerchantBankCardBuilder builder, ResultListener resultListener) throws RequestParamException, ResponseDecryptException {
        String url = ConfigurationUtils.getEnjoyMerchantBankCardSubmitUrl();
        try {
            HttpReponse response = HttpClientUtils.sdkPost(url, builder);
            Object decryptResponse = response.getDecryptResponse();
            if (!(decryptResponse instanceof JSONObject)) {
                throw new RuntimeException("server response error,response object not a json!");
            }
            JSONObject responseJson = (JSONObject)decryptResponse;
            if (response.success()) {
                String status = responseJson.getString(Constants.STATUS);
                if (StringUtils.isBlank((CharSequence)status) || Constants.SUCCESS.equals(status)) {
                    resultListener.success(responseJson);
                } else {
                    resultListener.failure(responseJson);
                }
            } else {
                LOGGER.error("submit request response error,errorCode:{}", (Object)response.getResponseCode());
                resultListener.failure(responseJson);
            }
        }
        catch (RequestParamException e) {
            LOGGER.error("submit request url:[{}]", (Object)url, (Object)e);
            throw e;
        }
        catch (ResponseDecryptException e) {
            LOGGER.error("submit request url:[{}] ", (Object)url, (Object)e);
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("submit request url:[{}]", (Object)url, (Object)e);
            throw new UnknownException(e);
        }
    }

    public void setDefault(MerchantBankCardSetDefaultBuilder builder, ResultListener listener) throws RequestParamException, ResponseDecryptException {
        String url = ConfigurationUtils.getEnjoyMerchantBankCardSetDefaultUrl();
        try {
            HttpReponse response = HttpClientUtils.sdkPost(url, builder);
            Object decryptResponse = response.getDecryptResponse();
            if (!(decryptResponse instanceof JSONObject)) {
                throw new RuntimeException("server response error,response object not a json!");
            }
            JSONObject responseJson = (JSONObject)decryptResponse;
            if (response.success()) {
                String status = responseJson.getString(Constants.STATUS);
                if (StringUtils.isBlank((CharSequence)status) || Constants.SUCCESS.equals(status)) {
                    listener.success(responseJson);
                } else {
                    listener.failure(responseJson);
                }
            } else {
                LOGGER.error("setDefault request response error,errorCode:{}", (Object)response.getResponseCode());
                listener.failure(responseJson);
            }
        }
        catch (RequestParamException e) {
            LOGGER.error("setDefault request url:[{}]", (Object)url, (Object)e);
            throw e;
        }
        catch (ResponseDecryptException e) {
            LOGGER.error("setDefault request url:[{}] ", (Object)url, (Object)e);
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("setDefault request url:[{}]", (Object)url, (Object)e);
            throw new UnknownException(e);
        }
    }

    public void unbind(MerchantBankCardUnbindBuilder builder, ResultListener listener) throws RequestParamException, ResponseDecryptException {
        String url = ConfigurationUtils.getEnjoyMerchantBankCardUnbindUrl();
        try {
            HttpReponse response = HttpClientUtils.sdkPost(url, builder);
            Object decryptResponse = response.getDecryptResponse();
            if (!(decryptResponse instanceof JSONObject)) {
                throw new RuntimeException("server response error,response object not a json!");
            }
            JSONObject responseJson = (JSONObject)decryptResponse;
            if (response.success()) {
                String status = responseJson.getString(Constants.STATUS);
                if (StringUtils.isBlank((CharSequence)status) || Constants.SUCCESS.equals(status)) {
                    listener.success(responseJson);
                } else {
                    listener.failure(responseJson);
                }
            } else {
                LOGGER.error("unbind request response error,errorCode:{}", (Object)response.getResponseCode());
                listener.failure(responseJson);
            }
        }
        catch (RequestParamException e) {
            LOGGER.error("unbind request url:[{}]", (Object)url, (Object)e);
            throw e;
        }
        catch (ResponseDecryptException e) {
            LOGGER.error("unbind request url:[{}] ", (Object)url, (Object)e);
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("unbind request url:[{}]", (Object)url, (Object)e);
            throw new UnknownException(e);
        }
    }
}

