/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.easepay.executer;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.Constants;
import com.upay.sdk.HttpClientUtils;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.easepay.builder.EasePayCreateBuilder;
import com.upay.sdk.exception.ResponseException;
import com.upay.sdk.exception.UnknownException;
import com.upay.sdk.executer.Executer;
import com.upay.sdk.executer.ResultListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EasePayExecuter
extends Executer {
    static final Logger LOGGER = LoggerFactory.getLogger(EasePayExecuter.class);

    public void bothCreate(EasePayCreateBuilder builder, ResultListener resultListener) {
        block5: {
            try {
                JSONObject requestData = builder.bothEncryptBuild();
                LOGGER.debug("bothCreate requestData:[" + requestData.toJSONString() + "]");
                String responseStr = HttpClientUtils.post3(ConfigurationUtils.getEasePayCreateOrderUrl(), requestData);
                LOGGER.debug("bothCreate responseStr:[" + responseStr + "]");
                JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
                responseData = CipherWrapper.bothDecryptWrap(responseData);
                if (null == responseData) {
                    throw new ResponseException(responseData);
                }
                String status = responseData.getString(Constants.STATUS);
                LOGGER.info("bothCreate responseStr status:[" + status + "]");
                this.bothVerifyHmacOrder(responseData);
                if (Constants.SUCCESS.equals(status)) {
                    resultListener.success(responseData);
                    break block5;
                }
                if (Constants.FAILED.equals(status)) {
                    resultListener.failure(responseData);
                    break block5;
                }
                throw new ResponseException(responseData);
            }
            catch (Exception e) {
                LOGGER.error("easepay bothCreate error", (Throwable)e);
                throw new UnknownException(e);
            }
        }
    }
}

