/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.declaration.v_3.builder;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.exception.UnknownException;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public final class BillingOrderBuilder
extends BuilderSupport {
    private String merchantId;
    private String requestId;
    private String subMerchantId;
    private String billingMode;
    private String feeType;
    private String feeValue;
    private String minFeeAmount;
    private String maxFeeAmount;

    public BillingOrderBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public BillingOrderBuilder setMerchantId(String merchantId) {
        this.merchantId = StringUtils.isBlank((CharSequence)merchantId) ? null : merchantId;
        return this;
    }

    public BillingOrderBuilder setRequestId(String requestId) {
        this.requestId = StringUtils.isBlank((CharSequence)requestId) ? null : requestId;
        return this;
    }

    public BillingOrderBuilder setSubMerchantId(String subMerchantId) {
        this.subMerchantId = StringUtils.isBlank((CharSequence)subMerchantId) ? null : subMerchantId;
        return this;
    }

    public BillingOrderBuilder setBillingMode(String billingMode) {
        this.billingMode = StringUtils.isBlank((CharSequence)billingMode) ? null : billingMode;
        return this;
    }

    public BillingOrderBuilder setFeeType(String feeType) {
        this.feeType = StringUtils.isBlank((CharSequence)feeType) ? null : feeType;
        return this;
    }

    public BillingOrderBuilder setFeeValue(String feeValue) {
        this.feeValue = StringUtils.isBlank((CharSequence)feeValue) ? null : feeValue;
        return this;
    }

    public BillingOrderBuilder setMinFeeAmount(String minFeeAmount) {
        this.minFeeAmount = StringUtils.isBlank((CharSequence)minFeeAmount) ? null : minFeeAmount;
        return this;
    }

    public BillingOrderBuilder setMaxFeeAmount(String maxFeeAmount) {
        this.maxFeeAmount = StringUtils.isBlank((CharSequence)maxFeeAmount) ? null : maxFeeAmount;
        return this;
    }

    public JSONObject build() {
        JSONObject json = super.build(this.merchantId);
        if (StringUtils.isNotBlank((CharSequence)this.merchantId)) {
            json.put("merchantId", (Object)this.merchantId);
        }
        if (StringUtils.isNotBlank((CharSequence)this.requestId)) {
            json.put("requestId", (Object)this.requestId);
        }
        if (StringUtils.isNotBlank((CharSequence)this.subMerchantId)) {
            json.put("subMerchantId", (Object)this.subMerchantId);
        }
        if (StringUtils.isNotBlank((CharSequence)this.billingMode)) {
            json.put("billingMode", (Object)this.billingMode);
        }
        if (StringUtils.isNotBlank((CharSequence)this.feeType)) {
            json.put("feeType", (Object)this.feeType);
        }
        if (StringUtils.isNotBlank((CharSequence)this.feeValue)) {
            json.put("feeValue", (Object)this.feeValue);
        }
        if (StringUtils.isNotBlank((CharSequence)this.minFeeAmount)) {
            json.put("minFeeAmount", (Object)this.minFeeAmount);
        }
        if (StringUtils.isNotBlank((CharSequence)this.maxFeeAmount)) {
            json.put("maxFeeAmount", (Object)this.maxFeeAmount);
        }
        json.put("hmac", (Object)this.generateHmac());
        return json;
    }

    private String generateHmac() {
        StringBuilder hmacSource = new StringBuilder();
        hmacSource.append(StringUtils.defaultString((String)this.merchantId)).append(StringUtils.defaultString((String)this.requestId, (String)"")).append(StringUtils.defaultString((String)this.subMerchantId, (String)"")).append(StringUtils.defaultString((String)this.billingMode, (String)"")).append(StringUtils.defaultString((String)this.feeType, (String)"")).append((String)ObjectUtils.defaultIfNull((Object)this.feeValue, (Object)"")).append((String)ObjectUtils.defaultIfNull((Object)this.minFeeAmount, (Object)"")).append((String)ObjectUtils.defaultIfNull((Object)this.maxFeeAmount, (Object)""));
        return SignUtils.signMd5(hmacSource.toString(), ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject encryptBuild() {
        JSONObject json = super.assembleBuild();
        json.put("hmac", (Object)this.orderGenerateHmac());
        return CipherWrapper.encryptWrap(this.merchantId, json);
    }

    @Override
    protected String orderGenerateHmac() {
        String orderGenerateHmac = super.orderGenerateHmac();
        String hmacKey = ConfigurationUtils.getHmacKey(this.merchantId);
        return SignUtils.signMd5(orderGenerateHmac, hmacKey);
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }
}

