/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.currencyexchange.builder;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.exception.UnknownException;

public class CalculateFeeBuilder
extends BuilderSupport {
    private String merchantId;
    private String currency;
    private String amount;
    private String feeCharge;

    public CalculateFeeBuilder(String merchantId, String currency, String amount, String feeCharge) {
        this.merchantId = merchantId;
        this.currency = currency;
        this.amount = amount;
        this.feeCharge = feeCharge;
    }

    public CalculateFeeBuilder setMerchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    public CalculateFeeBuilder setCurrency(String currency) {
        this.currency = currency;
        return this;
    }

    public CalculateFeeBuilder setAmount(String amount) {
        this.amount = amount;
        return this;
    }

    public CalculateFeeBuilder setFeeCharge(String feeCharge) {
        this.feeCharge = feeCharge;
        return this;
    }

    public String getMerchantId() {
        return this.merchantId;
    }

    public String getCurrency() {
        return this.currency;
    }

    public String getAmount() {
        return this.amount;
    }

    public String getFeeCharge() {
        return this.feeCharge;
    }

    @Override
    protected String orderGenerateHmac() {
        return SignUtils.signMd5(super.orderGenerateHmac(), ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }
}

