/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.core.response;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.Constants;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.core.response.HttpReponse;
import com.upay.sdk.exception.HmacVerifyException;
import com.upay.sdk.exception.RequestException;
import com.upay.sdk.exception.ResponseDecryptException;
import java.util.Map;

public class HttpJsonResponse
extends HttpReponse<JSONObject> {
    private final JSONObject response;
    private JSONObject decryptResponse;

    public HttpJsonResponse(int responseCode, String responseBody, Map<String, Object> otherProperties) {
        super(responseCode);
        this.response = JSON.parseObject((String)responseBody);
        if (otherProperties != null && !otherProperties.isEmpty()) {
            this.response.putAll(otherProperties);
        }
    }

    @Override
    public String getOriginalString() {
        return this.response.toJSONString();
    }

    @Override
    public JSONObject getDecryptResponse() {
        return this.decryptResponse;
    }

    @Override
    public void verifyHmac() throws HmacVerifyException {
        if (this.decryptResponse == null) {
            throw new HmacVerifyException("plase decryptResponse!");
        }
        if (!this.success()) {
            throw new RequestException("response code is " + this.getResponseCode() + "!");
        }
        if (this.decryptResponse.containsKey((Object)Constants.HMAC)) {
            try {
                this.bothVerifyHmacOrder(this.decryptResponse);
            }
            catch (Exception e) {
                throw new HmacVerifyException(e);
            }
        }
    }

    @Override
    public void decryptResponse() throws ResponseDecryptException {
        try {
            this.decryptResponse = CipherWrapper.bothDecryptWrap(this.response);
        }
        catch (Exception e) {
            throw new ResponseDecryptException(e);
        }
    }
}

