/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.cashier.order.builder;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.exception.UnknownException;
import org.apache.commons.lang3.StringUtils;

public class ReceiptPaymentBuilder
extends BuilderSupport {
    private String merchantId;
    private String requestId;
    private String paymentOrderId;
    private String kaptchaCode;
    private String cvv2;
    private String expiryDate;
    private String partnerId;

    public String getPartnerId() {
        return this.partnerId;
    }

    public ReceiptPaymentBuilder setPartnerId(String partnerId) {
        this.partnerId = partnerId;
        return this;
    }

    public ReceiptPaymentBuilder setKaptchaCode(String kaptchaCode) {
        this.kaptchaCode = kaptchaCode;
        return this;
    }

    public ReceiptPaymentBuilder setMerchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    public ReceiptPaymentBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public ReceiptPaymentBuilder setPaymentOrderId(String paymentOrderId) {
        this.paymentOrderId = paymentOrderId;
        return this;
    }

    public String getCvv2() {
        return this.cvv2;
    }

    public ReceiptPaymentBuilder setCvv2(String cvv2) {
        this.cvv2 = cvv2;
        return this;
    }

    public String getExpiryDate() {
        return this.expiryDate;
    }

    public ReceiptPaymentBuilder setExpiryDate(String expiryDate) {
        this.expiryDate = expiryDate;
        return this;
    }

    public ReceiptPaymentBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public JSONObject build() {
        JSONObject json = super.build(this.merchantId);
        if (StringUtils.isNotBlank((CharSequence)this.requestId)) {
            json.put("requestId", (Object)this.requestId);
        }
        if (StringUtils.isNotBlank((CharSequence)this.kaptchaCode)) {
            json.put("kaptchaCode", (Object)this.kaptchaCode);
        }
        if (StringUtils.isNotBlank((CharSequence)this.cvv2)) {
            json.put("cvv2", (Object)this.cvv2);
        }
        if (StringUtils.isNotBlank((CharSequence)this.expiryDate)) {
            json.put("expiryDate", (Object)this.expiryDate);
        }
        json.put("hmac", (Object)this.generateHmac());
        return json;
    }

    private String generateHmac() {
        StringBuilder hmacSource = new StringBuilder();
        hmacSource.append(StringUtils.defaultString((String)this.merchantId)).append(StringUtils.defaultString((String)this.requestId)).append(StringUtils.defaultString((String)this.kaptchaCode)).append(StringUtils.defaultString((String)this.cvv2)).append(StringUtils.defaultString((String)this.expiryDate));
        return SignUtils.signMd5(hmacSource.toString(), ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject encryptBuild() {
        JSONObject json = super.assembleBuild();
        json.put("hmac", (Object)this.orderGenerateHmac());
        return CipherWrapper.encryptWrap(this.merchantId, json);
    }

    @Override
    protected String orderGenerateHmac() {
        String orderGenerateHmac = super.orderGenerateHmac();
        String hmacKey = ConfigurationUtils.getHmacKey(this.merchantId);
        return SignUtils.signMd5(orderGenerateHmac, hmacKey);
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        if (StringUtils.isNotBlank((CharSequence)this.partnerId)) {
            return CipherWrapper.bothEncryptWrap(this.merchantId, this.partnerId, json);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }
}

