/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk;

import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FastJsonUtils {
    static final Logger LOGGER = LoggerFactory.getLogger(FastJsonUtils.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JSONObject convert(InputStream inputStream) {
        byte[] buffer = new byte[1024];
        int len = 0;
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            JSONObject jsonObject;
            while ((len = inputStream.read(buffer, 0, buffer.length)) != -1) {
                out.write(buffer, 0, len);
            }
            byte[] bytes = out.toByteArray();
            String jsonStr = new String(bytes, "UTF-8");
            JSONObject jSONObject = jsonObject = JSONObject.parseObject((String)jsonStr);
            return jSONObject;
        }
        catch (IOException e) {
            LOGGER.info("", (Throwable)e);
            return null;
        }
    }
}

