/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk;

import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConfigurationUtils {
    static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationUtils.class);
    private static boolean customSource;
    private static final String PUBLIC = ".public";
    public static final String CONFIG_FILE = "5upay-config.properties";

    private static String getString(String key) {
        String value = StringUtils.trim((String)Holder.config.getString(key));
        if (StringUtils.isBlank((CharSequence)value)) {
            LOGGER.warn("ConfigurationUtils.getString:[" + key + "] is blank");
        }
        return value;
    }

    private static Integer getInteger(String key, Integer defaultValue) {
        return Holder.config.getInteger(key, defaultValue);
    }

    public static String getPublicKey(String merchantId) {
        return ConfigurationUtils.getString(merchantId + PUBLIC);
    }

    public static String getHmacKey(String merchantId) {
        return ConfigurationUtils.getString(merchantId);
    }

    public static String getForeignExchangeOrderUrl() {
        return ConfigurationUtils.getString("foreignexchange.order.url");
    }

    public static String getForeignExchangeQueryUrl() {
        return ConfigurationUtils.getString("foreignexchange.query.url");
    }

    public static String getForeignExchangeRefundUrl() {
        return ConfigurationUtils.getString("foreignexchange.refund.url");
    }

    public static String getForeignExchangeRefundQueryUrl() {
        return ConfigurationUtils.getString("foreignexchange.refund.query.url");
    }

    public static String getForeignExchangeListpriceLockUrl() {
        return ConfigurationUtils.getString("foreignexchange.listpricelock.url");
    }

    public static String getForeignExchangeTransferOrderUrl() {
        return ConfigurationUtils.getString("foreignexchange.transfer.order.url");
    }

    public static String getForeignExchangeTransferQueryUrl() {
        return ConfigurationUtils.getString("foreignexchange.transfer.query.url");
    }

    public static String getOnlinePayOrderUrl() {
        return ConfigurationUtils.getString("onlinepay.order.url");
    }

    public static String getAppDemoOnlinePayOrderMerchantId() {
        return ConfigurationUtils.getString("appDemo.onlinepay.order.merchantId");
    }

    public static String getAppDemoOnlinePayOrderAppid() {
        return ConfigurationUtils.getString("appDemo.onlinepay.order.appid");
    }

    public static String getAppDemoIccCashierOrderMerchantId() {
        return ConfigurationUtils.getString("appDemo.icc.order.cashier.merchantId");
    }

    public static String getAppDemoIccCashierOrderTerminalNo() {
        return ConfigurationUtils.getString("appDemo.icc.order.cashier.terminalNo");
    }

    public static String getAppDemoSdkWeb() {
        return ConfigurationUtils.getString("appDemo.sdk.web");
    }

    public static String getCancelOrderUrl() {
        return ConfigurationUtils.getString("onlinepay.cancelOrder.url");
    }

    public static String getOnlinePaySplitOrderUrl() {
        return ConfigurationUtils.getString("onlinepay.split.order.url");
    }

    public static String getOnlinePaySplitOrderQueryUrl() {
        return ConfigurationUtils.getString("onlinepay.split.order.query.url");
    }

    public static String getOnlinePayQueryUrl() {
        return ConfigurationUtils.getString("onlinepay.query.url");
    }

    public static String getOnlinePayRefundUrl() {
        return ConfigurationUtils.getString("onlinepay.refund.url");
    }

    public static String getOnlinePayRefundQueryUrl() {
        return ConfigurationUtils.getString("onlinepay.refund.query.url");
    }

    public static String getTransferOrderUrl() {
        return ConfigurationUtils.getString("transfer.order.url");
    }

    public static String getTransferQueryUrl() {
        return ConfigurationUtils.getString("transfer.query.url");
    }

    public static String getTransferValidateUrl() {
        return ConfigurationUtils.getString("transfer.validate.url");
    }

    public static String getTransferValidateQueryUrl() {
        return ConfigurationUtils.getString("transfer.validate.query.url");
    }

    public static String getTransferListpriceLockUrl() {
        return ConfigurationUtils.getString("transfer.listpricelock.url");
    }

    public static String getHgOrderUrl() {
        return ConfigurationUtils.getString("hg.order.url");
    }

    public static String getHgMemberUrl() {
        return ConfigurationUtils.getString("hg.member.url");
    }

    public static String getHgMemberQueryUrl() {
        return ConfigurationUtils.getString("hg.member.query.url");
    }

    public static String getHgQueryUrl() {
        return ConfigurationUtils.getString("hg.query.url");
    }

    public static String getHgPayOrderQueryUrl() {
        return ConfigurationUtils.getString("hg.pay.order.query");
    }

    public static String getBankChannelQueryUrl() {
        return ConfigurationUtils.getString("bankchannel.query.url");
    }

    public static String getCreditQueryOrderUrl() {
        return ConfigurationUtils.getString("rz.credit.url");
    }

    public static String getRzOrderUrl() {
        return ConfigurationUtils.getString("rz.auth.url");
    }

    public static String getRzQueryUrl() {
        return ConfigurationUtils.getString("rz.search.url");
    }

    public static String getRzAuthTransferUrl() {
        return ConfigurationUtils.getString("rz.authtransfer.order.url");
    }

    public static String getRzAuthTransferQueryUrl() {
        return ConfigurationUtils.getString("rz.authtransfer.query.url");
    }

    public static String getQuickRechargeOrderUrl() {
        return ConfigurationUtils.getString("quickrecharge.order.url");
    }

    public static String getQuickRechargeUrl() {
        return ConfigurationUtils.getString("quickrecharge.query.url");
    }

    public static String getTransferDomesticOrderUrl() {
        return ConfigurationUtils.getString("transferDomestic.order.url");
    }

    public static String getTransferDomesticBatchOrderUrl() {
        return ConfigurationUtils.getString("transferDomestic.batch.order.url");
    }

    public static String getTransferDomesticQueryUrl() {
        return ConfigurationUtils.getString("transferDomestic.query.url");
    }

    public static String getTransferAccountOrderUrl() {
        return ConfigurationUtils.getString("transferAccount.order.url");
    }

    public static String getTransferAccountQueryUrl() {
        return ConfigurationUtils.getString("transferAccount.query.url");
    }

    public static String getTransferAccountGenerateTransferVoucherUrl() {
        return ConfigurationUtils.getString("transferAccount.generateTransferVoucher.url");
    }

    public static String getTransferDomesticGenerateTransferVoucherUrl() {
        return ConfigurationUtils.getString("transferDomestic.generateTransferVoucher.url");
    }

    public static String getTransferDomesticSingleOrderUrl() {
        return ConfigurationUtils.getString("transferDomestic.single.order.url");
    }

    public static String getTransferDomesticSingleQueryUrl() {
        return ConfigurationUtils.getString("transferDomestic.single.query.url");
    }

    public static String getTransferDomesticAccountAvailableBalanceUrl() {
        return ConfigurationUtils.getString("transferDomestic.account.availableBalance.url");
    }

    public static String getCustomsOrderUrl() {
        return ConfigurationUtils.getString("customs.order.url");
    }

    public static String getCustomsQueryUrl() {
        return ConfigurationUtils.getString("customs.query.url");
    }

    public static String getForeignCustomsReportUrl() {
        return ConfigurationUtils.getString("foreign.customs.report.url");
    }

    public static String getForeignCustomsReportQueryUrl() {
        return ConfigurationUtils.getString("foreign.customs.report.query.url");
    }

    public static String getCustomsRepeatDeclareUrl() {
        return ConfigurationUtils.getString("customs.repeatDeclare.url");
    }

    public static String getHgTransferOrderURl() {
        return ConfigurationUtils.getString("hg.transferorder.url");
    }

    public static String getHgPayOrderUrl() {
        return ConfigurationUtils.getString("hg.payorder.url");
    }

    public static String getDestroyOrderUrl() {
        return ConfigurationUtils.getString("prepay.destroy.url");
    }

    public static String getDestroyQueryUrl() {
        return ConfigurationUtils.getString("prepay.destroyQuery.url");
    }

    public static String getPrepaySellOrderURl() {
        return ConfigurationUtils.getString("prepay.sell.order.url");
    }

    public static String getPrepaySellQueryURl() {
        return ConfigurationUtils.getString("prepay.sell.query.url");
    }

    public static String getRechareUrl() {
        return ConfigurationUtils.getString("hg.recharge.url");
    }

    public static String getRechareQueryUrl() {
        return ConfigurationUtils.getString("hg.recharge.query.url");
    }

    public static String getHgTransferQueryUrl() {
        return ConfigurationUtils.getString("hg.transfer.query.url");
    }

    public static String getHgAccountQueryUrl() {
        return ConfigurationUtils.getString("hg.account.query.url");
    }

    public static Integer getConnectTimeout() {
        return ConfigurationUtils.getInteger("ehking.sdk.net.client.defaultConnectTimeout", null);
    }

    public static Integer getReadTimeout() {
        return ConfigurationUtils.getInteger("ehking.sdk.net.client.defaultReadTimeout", null);
    }

    public static String getWithholdingOrderUrl() {
        return ConfigurationUtils.getString("withholding.order.url");
    }

    public static String getWithholdingQueryUrl() {
        return ConfigurationUtils.getString("withholding.query.url");
    }

    public static String getWithholdingOrderBatchUrl() {
        return ConfigurationUtils.getString("withholding.orderBatch.url");
    }

    public static String getForeignpayExchangesettlementOrderBatchUrl() {
        return ConfigurationUtils.getString("foreignpayExchangesettlement.orderBatch.url");
    }

    public static String getForeignpayExchangesettlementQueryBatchUrl() {
        return ConfigurationUtils.getString("foreignpayExchangesettlement.queryBatch.url");
    }

    public static String getPcardOnlinePayOrderUrl() {
        return ConfigurationUtils.getString("prepaycard.order.url");
    }

    public static String getPcardOnlinePayQueryUrl() {
        return ConfigurationUtils.getString("prepaycard.query.url");
    }

    public static String getPcardBalanceCardQueryUrl() {
        return ConfigurationUtils.getString("prepaycard.balance.card.query.url");
    }

    public static String getPcardDestroyCardQueryUrl() {
        return ConfigurationUtils.getString("prepaycard.destroy.card.query.url");
    }

    public static String getMemberBalanceQueryUrl() {
        return ConfigurationUtils.getString("member.query.balance.url");
    }

    public static String getPhoenixOrderUrl() {
        return ConfigurationUtils.getString("phoenix.order.url");
    }

    public static String getPhoenixReportUrl() {
        return ConfigurationUtils.getString("phoenix.report.url");
    }

    public static String getPhoenixQueryUrl() {
        return ConfigurationUtils.getString("phoenix.query.url");
    }

    public static String getPhoenixRefundUrl() {
        return ConfigurationUtils.getString("phoenix.refund.url");
    }

    public static String getPhoenixRefundQueryUrl() {
        return ConfigurationUtils.getString("phoenix.refund.query.url");
    }

    public static String getPhoenixUserCreateUrl() {
        return ConfigurationUtils.getString("phoenix.user.create.url");
    }

    public static String getPhoenixUserQueryUrl() {
        return ConfigurationUtils.getString("phoenix.user.query.url");
    }

    public static String getJointUploadQualificationUrl() {
        return ConfigurationUtils.getString("joint.upload.qualification.url");
    }

    public static String getJointaccountCreateUrl() {
        return ConfigurationUtils.getString("joint.create.url");
    }

    public static String getJointaccountQueryCreateUrl() {
        return ConfigurationUtils.getString("joint.query.url");
    }

    public static String getJAccountQueryCreateUrl() {
        return ConfigurationUtils.getString("joint.query.jaccount.url");
    }

    public static String getJointQualificationQueryUrl() {
        return ConfigurationUtils.getString("joint.qualification.query.url");
    }

    public static String getJointTransferOrderCreateUrl() {
        return ConfigurationUtils.getString("joint.transfer.order.create.url");
    }

    public static String getJointTransferOrderQueryUrl() {
        return ConfigurationUtils.getString("joint.transfer.order.query.url");
    }

    public static String getJointSettlementProfileUrl() {
        return ConfigurationUtils.getString("joint.settlement.profile.url");
    }

    public static String getJointSettlementProfileQueryUrl() {
        return ConfigurationUtils.getString("joint.settlement.profile.query.url");
    }

    public static String getJointOnlinePayOrderUrl() {
        return ConfigurationUtils.getString("joint.onlinepay.order.url");
    }

    public static String getReportModifyUrl() {
        return ConfigurationUtils.getString("phoenix.report.modify.url");
    }

    public static String getWeilianbaoModifyUrl() {
        return StringUtils.trim((String)Holder.config.getString("phoenix.weilianbao.modify.url"));
    }

    public static String getProxyOnlinePayOrderUrl() {
        return ConfigurationUtils.getString("proxy.onlinePay.order.url");
    }

    public static String getHttpContentType() {
        return ConfigurationUtils.getString("http.content.type");
    }

    public static String getHttpContentTypeV2() {
        return ConfigurationUtils.getString("http.content.type.v2");
    }

    public static String getHttpContentTypeV3() {
        return ConfigurationUtils.getString("http.content.type.v3");
    }

    public static String getHttpContentTypeV4() {
        return ConfigurationUtils.getString("http.content.type.v4");
    }

    public static String getConsumerFinanceOrderUrl() {
        return ConfigurationUtils.getString("consumerFinance.order.url");
    }

    public static String getConsumerFinanceRepaymentQueryUrl() {
        return ConfigurationUtils.getString("consumerFinance.repayment.query.url");
    }

    public static String getConsumerFinanceOrderQueryUrl() {
        return ConfigurationUtils.getString("consumerFinance.order.query.url");
    }

    public static String getPhoenixUnBindCardUrl() {
        return ConfigurationUtils.getString("phoenix.unbind.url");
    }

    public static String getPhoenixBindCardUrl() {
        return ConfigurationUtils.getString("phoenix.bind.url");
    }

    public static String getPhoenixBindCardConfirmUrl() {
        return ConfigurationUtils.getString("phoenix.bindConfirm.url");
    }

    public static String getPhoenixBindCardQueryUrl() {
        return ConfigurationUtils.getString("phoenix.bindQuery.url");
    }

    @Deprecated
    public static String getServerPublicKey() {
        return ConfigurationUtils.getString("server.public.key.path");
    }

    public static String getServerPublicKey(String merchantId) {
        String publishKey;
        if (StringUtils.isNotBlank((CharSequence)merchantId) && StringUtils.isNotBlank((CharSequence)(publishKey = ConfigurationUtils.getString(merchantId + ".server.public.key.path")))) {
            return publishKey;
        }
        return ConfigurationUtils.getString("server.public.key.path");
    }

    public static String getClientCryptoType(String merchantId) {
        return StringUtils.trim((String)Holder.config.getString(merchantId + ".client.crypto"));
    }

    public static String getClientPrivateKeyPath(String merchantId) {
        return ConfigurationUtils.getString(merchantId + ".client.private.key.path");
    }

    public static String getClientPrivateKeyPassword(String merchantId) {
        return ConfigurationUtils.getString(merchantId + ".client.private.key.password");
    }

    public static String getErtTradeRemitOrderUrl() {
        return ConfigurationUtils.getString("ert.trade.remit.order.url");
    }

    public static String getErtTradeRemitOrderQueryUrl() {
        return ConfigurationUtils.getString("ert.trade.remit.order.query.url");
    }

    public static String getErtBindCardUrl() {
        return ConfigurationUtils.getString("ert.bindcard.request.url");
    }

    public static String getErtBindCardConfirmUrl() {
        return ConfigurationUtils.getString("ert.bindcard.confirm.url");
    }

    public static String getErtBindCardQueryUrl() {
        return ConfigurationUtils.getString("ert.bindcard.query.url");
    }

    public static String getErtUnBindCardUrl() {
        return ConfigurationUtils.getString("ert.bindcard.unbind.url");
    }

    public static String getErtBindCardUrlV2() {
        return ConfigurationUtils.getString("ert.v2.bindcard.request.url");
    }

    public static String getErtBindCardConfirmUrlV2() {
        return ConfigurationUtils.getString("ert.v2.bindcard.confirm.url");
    }

    public static String getErtBindCardQueryUrlV2() {
        return ConfigurationUtils.getString("ert.v2.bindcard.query.url");
    }

    public static String getErtUnBindCardUrlV2() {
        return ConfigurationUtils.getString("ert.v2.bindcard.unbind.url");
    }

    public static String getErtReceiptOrderUrlV2() {
        return ConfigurationUtils.getString("ert.v2.order.url");
    }

    public static String getErtOrderQueryUrlV2() {
        return ConfigurationUtils.getString("ert.v2.query.url");
    }

    public static String getErtReceiptPaymentUrlV2() {
        return ConfigurationUtils.getString("ert.v2.order.payment.url");
    }

    public static String getErtUserLaunchRemitOrderUrlV2() {
        return ConfigurationUtils.getString("ert.v2.user.remit.url");
    }

    public static String getErtUserLaunchTradeRemitQueryUrlV2() {
        return ConfigurationUtils.getString("ert.v2.user.remit.query.url");
    }

    public static String getErtMerchantCommissionRemitUrlV2() {
        return ConfigurationUtils.getString("ert.v2.merchant.remit.url");
    }

    public static String getErtMerchantCommissionRemitQueryUrlV2() {
        return ConfigurationUtils.getString("ert.v2.merchant.remit.query.url");
    }

    public static String getErtUserBalanceQueryUrlV2() {
        return ConfigurationUtils.getString("ert.v2.user.balance.query.url");
    }

    public static String getErtUserSignUp() {
        return ConfigurationUtils.getString("ert.user.signUp.url");
    }

    public static String getMerchantUserSignUp() {
        return ConfigurationUtils.getString("ert.v2.merchant.signUp.url");
    }

    public static String getErtOrderUrl() {
        return ConfigurationUtils.getString("ert.order.url");
    }

    public static String getErtQueryUrl() {
        return ConfigurationUtils.getString("ert.query.url");
    }

    public static String getErtQuerySubMerchantUrl() {
        return ConfigurationUtils.getString("ert.query.submerchant.url");
    }

    public static String getErtCommissionRemitOrderUrl() {
        return ConfigurationUtils.getString("ert.commission.remit.order.url");
    }

    public static String getErtCommissionRemitOrderQueryUrl() {
        return ConfigurationUtils.getString("ert.commission.remit.order.query.url");
    }

    public static String getErtUserBalanceQueryUrl() {
        return ConfigurationUtils.getString("ert.user.balance.query.url");
    }

    public static String getErtMerchantReportUrl() {
        return ConfigurationUtils.getString("ert.v2.merchant.report.url");
    }

    public static String getErtMerchantReportQueryUrl() {
        return ConfigurationUtils.getString("ert.v2.merchant.report.query.url");
    }

    public static String getErtMerchantWechatConfigUrl() {
        return ConfigurationUtils.getString("ert.v2.merchant.wechat.config.url");
    }

    public static String getErtMerchantWechatConfigQueryUrl() {
        return ConfigurationUtils.getString("ert.v2.merchant.wechat.config.query.url");
    }

    public static String getNewRetailSplitOrderUrl() {
        return ConfigurationUtils.getString("newretail.split.order.url");
    }

    public static String getNewRetailOrderUrl() {
        return ConfigurationUtils.getString("newretail.create.order.url");
    }

    public static String getNewRetailOrderQueryUrl() {
        return ConfigurationUtils.getString("newretail.query.order.url");
    }

    public static String getNewRetailOrderRefundUrl() {
        return ConfigurationUtils.getString("newretail.order.refund.url");
    }

    public static String getNewRetailOrderRefundQueryUrl() {
        return ConfigurationUtils.getString("newretail.order.refund.query.url");
    }

    public static String getNewRetailOrderExtendGuaranteeUrl() {
        return ConfigurationUtils.getString("newretail.order.extend.guarantee.url");
    }

    public static String getNewRetailQueryAccountUrl() {
        return ConfigurationUtils.getString("newretail.query.account.url");
    }

    public static String getNewRetailGuaranteeFinishUrl() {
        return ConfigurationUtils.getString("newretail.order.guarantee.complete.url");
    }

    public static String getNewRetailBindCardUrl() {
        return ConfigurationUtils.getString("newretail.bindCard.request.url");
    }

    public static String getNewRetailBindCardConfirmUrl() {
        return ConfigurationUtils.getString("newretail.bindCard.confirm.url");
    }

    public static String getNewRetailBindCardQueryUrl() {
        return ConfigurationUtils.getString("newretail.bindCard.query.url");
    }

    public static String getNewRetailUnBindCardUrl() {
        return ConfigurationUtils.getString("newretail.bindCard.unbind.url");
    }

    public static String getNewRetailSubsidyOrderUrl() {
        return ConfigurationUtils.getString("newretail.subsidy.order.url");
    }

    public static String getNewRetailSubsidyOrderQueryUrl() {
        return ConfigurationUtils.getString("newretail.subsidy.orderQuery.url");
    }

    public static String getNewRetailSubsidyRefundUrl() {
        return ConfigurationUtils.getString("newretail.subsidy.refund.url");
    }

    public static String getNewRetailSubsidyRefundQueryUrl() {
        return ConfigurationUtils.getString("newretail.subsidy.refundQuery.url");
    }

    public static String getErtCommissionBalanceQueryUrl() {
        return ConfigurationUtils.getString("ert.commission.balance.query.url");
    }

    public static String getCashierBindCardQueryUrl() {
        return ConfigurationUtils.getString("cashier.bindcard.query.url");
    }

    public static String getCashierBindCardUrl() {
        return ConfigurationUtils.getString("cashier.bindcard.url");
    }

    public static String getCashierBindCardConfirmUrl() {
        return ConfigurationUtils.getString("cashier.bindcard.confirm.url");
    }

    public static String getCashierBindCardKaptchaUrl() {
        return ConfigurationUtils.getString("cashier.bindcard.kaptcha.url");
    }

    public static String getCashierUnBindCardUrl() {
        return ConfigurationUtils.getString("cashier.unbindcard.url");
    }

    public static String getCashierReceiptPaymentUrl() {
        return ConfigurationUtils.getString("cashier.receipt.payment.url");
    }

    public static String getCashierExclusiveAccountQueryUrl() {
        return ConfigurationUtils.getString("cashier.exclusive.account.query.url");
    }

    public static String getDeclarationSubMerchantDeclareUrl() {
        return ConfigurationUtils.getString("declaration.sub.merchant.declare.url");
    }

    public static String getDeclarationSubMerchantQueryUrl() {
        return ConfigurationUtils.getString("declaration.sub.merchant.query.url");
    }

    public static String getEshoppingGetPolicyUrl() {
        return ConfigurationUtils.getString("eshopping.getPolicy.url");
    }

    public static String getEshoppingOrderUrl() {
        return ConfigurationUtils.getString("eshopping.order.url");
    }

    public static String getEshoppingPayUrl() {
        return ConfigurationUtils.getString("eshopping.pay.url");
    }

    public static String getEshoppingQueryUrl() {
        return ConfigurationUtils.getString("eshopping.query.url");
    }

    public static String getEshoppingVccRechargeUrl() {
        return ConfigurationUtils.getString("eshopping.vccRecharge.url");
    }

    public static String getEshoppingApplyVccCardUrl() {
        return ConfigurationUtils.getString("eshopping.applyVccCard.url");
    }

    public static String getEshoppingQueryApplyVccCardUrl() {
        return ConfigurationUtils.getString("eshopping.queryApplyVccCard.url");
    }

    public static String getEshoppingCancelVccCardUrl() {
        return ConfigurationUtils.getString("eshopping.cancelVccCard.url");
    }

    public static String getEshoppingVccCardOrderServiceUrl() {
        return ConfigurationUtils.getString("eshopping.vccCardOrderService.url");
    }

    public static String getEshoppingCancelVccCardQueryUrl() {
        return ConfigurationUtils.getString("eshopping.cancelVccCardQuery.url");
    }

    public static String getEshoppingVccExpenseCreateUrl() {
        return ConfigurationUtils.getString("eshopping.vccExpenseCreate.url");
    }

    public static String getEshoppingVccExpenseQueryUrl() {
        return ConfigurationUtils.getString("eshopping.vccExpenseQuery.url");
    }

    public static String getEshoppingGetListPriceUrl() {
        return ConfigurationUtils.getString("eshopping.getListPrice.url");
    }

    public static String getEshoppingTransferAmountUrl() {
        return ConfigurationUtils.getString("eshopping.getTransferAmount.url");
    }

    public static String getEshoppingVccMerchantTradeOrderUrl() {
        return ConfigurationUtils.getString("eshopping.vccMerchantTradeOrder.url");
    }

    public static String getSettlementOrderUrl() {
        return ConfigurationUtils.getString("settlement.order.url");
    }

    public static String getBillingOrderUrl() {
        return ConfigurationUtils.getString("billing.order.url");
    }

    public static String getSettlementRuleQueryUrl() {
        return ConfigurationUtils.getString("settlement.rule.query.url");
    }

    public static String getWalletWithdrawUrl() {
        return ConfigurationUtils.getString("wallet.withdraw.url");
    }

    public static String getWalletWithdrawQueryUrl() {
        return ConfigurationUtils.getString("wallet.withdraw.query.url");
    }

    public static String getWalletWithdrawCertificateUrl() {
        return ConfigurationUtils.getString("wallet.withdraw.certificate.url");
    }

    public static String getIccConsumeApiOrderUrl() {
        return ConfigurationUtils.getString("icc.order.api.url");
    }

    public static String getIccApiTokenPayOrderUrl() {
        return ConfigurationUtils.getString("icc.order.api.token.url");
    }

    public static String getIccQueryOrderUrl() {
        return ConfigurationUtils.getString("icc.order.query.url");
    }

    public static String getIccPreauthConfirmUrl() {
        return ConfigurationUtils.getString("icc.order.preauthconfirm.url");
    }

    public static String getIccCashierOrderUrl() {
        return ConfigurationUtils.getString("icc.order.cashier.url");
    }

    public static String getIccOrderRefundUrl() {
        return ConfigurationUtils.getString("icc.order.refund.url");
    }

    public static String getIccRefundQueryUrl() {
        return ConfigurationUtils.getString("icc.refund.query.url");
    }

    public static String getIccOrderDeliveryUrl() {
        return ConfigurationUtils.getString("icc.order.delivery.url");
    }

    public static String getIccBrowseBackFillUrl() {
        return ConfigurationUtils.getString("icc.browse.backfill.url");
    }

    public static void setProperty(String key, Object value) {
        Holder.config.setProperty(key, value);
    }

    public static void setConfigSource(Configuration configSource) {
        if (configSource == null) {
            throw new IllegalArgumentException("configSource is null");
        }
        customSource = true;
        Holder.config = configSource;
    }

    public static String getWeboxRechargeUrl() {
        return ConfigurationUtils.getString("webox.recharge.create.url");
    }

    public static String getWeboxRechargeQueryUrl() {
        return ConfigurationUtils.getString("webox.recharge.query.url");
    }

    public static String getWeboxMerchantRechargeUrl() {
        return ConfigurationUtils.getString("webox.merchantRecharge.create.url");
    }

    public static String getWeboxMerchantRechargeBatchUrl() {
        return ConfigurationUtils.getString("webox.merchantRechargeBatch.create.url");
    }

    public static String getWeboxMerchantRechargeQueryUrl() {
        return ConfigurationUtils.getString("webox.merchantRecharge.query.url");
    }

    public static String getWeboxTransferCreateUrl() {
        return ConfigurationUtils.getString("webox.transfer.create.url");
    }

    public static String getWeboxOnlinePayCreateUrl() {
        return ConfigurationUtils.getString("webox.onlinepay.create.url");
    }

    public static String getWeboxOnlinePayQueryUrl() {
        return ConfigurationUtils.getString("webox.onlinepay.query.url");
    }

    public static String getWeboxOnlinePayRefundUrl() {
        return ConfigurationUtils.getString("webox.onlinepay.refund.url");
    }

    public static String getWeboxOnlinePayRefundQueryUrl() {
        return ConfigurationUtils.getString("webox.onlinepay.refund.query.url");
    }

    public static String getGetListPriceUrl() {
        return ConfigurationUtils.getString("listprice.getListPrice.url");
    }

    public static String getObtainListPriceUrl() {
        return ConfigurationUtils.getString("listprice.obtainListPrice.url");
    }

    public static String getWeboxTransferConfirmUrl() {
        return ConfigurationUtils.getString("webox.transfer.confirm.url");
    }

    public static String getWeboxTransferRefuseUrl() {
        return ConfigurationUtils.getString("webox.transfer.refuse.url");
    }

    public static String getWeboxTransferQueryUrl() {
        return ConfigurationUtils.getString("webox.transfer.query.url");
    }

    public static String getWeboxTransferTimeoutReturnUrl() {
        return ConfigurationUtils.getString("webox.transfer.timeoutReturn.url");
    }

    public static String getWeboxWithholdingUrl() {
        return ConfigurationUtils.getString("webox.withholding.create.url");
    }

    public static String getWeboxWithholdingDirectSubmitUrl() {
        return ConfigurationUtils.getString("webox.withholding.submit.url");
    }

    public static String getWeboxWithholdingAuthDirectSubmitUrl() {
        return ConfigurationUtils.getString("webox.withholding.authSubmit.url");
    }

    public static String getWeboxWithholdingQueryUrl() {
        return ConfigurationUtils.getString("webox.withholding.query.url");
    }

    public static String getWeboxRedPacketUrl() {
        return ConfigurationUtils.getString("webox.redpacket.create.url");
    }

    public static String getWeboxRedPacketQueryUrl() {
        return ConfigurationUtils.getString("webox.redpacket.query.url");
    }

    public static String getWeboxRedPacketGrabUrl() {
        return ConfigurationUtils.getString("webox.redpacket.grab.url");
    }

    public static String getWeboxRedPacketTimeoutReturnUrl() {
        return ConfigurationUtils.getString("webox.redpacket.timeoutReturn.url");
    }

    public static String getWeboxWalletUpdateWalletInfoUrl() {
        return ConfigurationUtils.getString("webox.wallet.updateWallet.url");
    }

    public static String getWeboxWalletCreateGrabUrl() {
        return ConfigurationUtils.getString("webox.wallet.create.url");
    }

    public static String getWeboxWalletUpdateIdCardPicUrl() {
        return ConfigurationUtils.getString("webox.wallet.updateIdCardPic.url");
    }

    public static String getWeboxBindCardSyncUrl() {
        return ConfigurationUtils.getString("webox.bindcard.sync.url");
    }

    public static String getWeboxBindCardListQuery() {
        return ConfigurationUtils.getString("webox.bindcard.list.url");
    }

    public static String getWeboxClientTokenCreateUrl() {
        return ConfigurationUtils.getString("webox.clienttoken.create.url");
    }

    public static String getWeboxValueAddedCreateUrl() {
        return ConfigurationUtils.getString("webox.value.added.create.url");
    }

    public static String getWeboxValueAddedQueryUserInfoUrl() {
        return ConfigurationUtils.getString("webox.value.added.query.userinfo.url");
    }

    public static String getWeboxWalletUpdateMobileUrl() {
        return ConfigurationUtils.getString("webox.wallet.updateMobile.url");
    }

    public static String getWeboxWalletQueryGrabUrl() {
        return ConfigurationUtils.getString("webox.wallet.query.url");
    }

    public static String getWeboxUserQuotaQueryUrl() {
        return ConfigurationUtils.getString("webox.user.quota.query.url");
    }

    public static String getWeboxWalletStatusModifyUrl() {
        return ConfigurationUtils.getString("webox.wallet.status.modify.url");
    }

    public static String getWeboxWalletBaseInfoQuery() {
        return ConfigurationUtils.getString("webox.wallet.query.baseInfo.url");
    }

    public static String getWeboxTradeRecordQueryUrl() {
        return ConfigurationUtils.getString("webox.tradeRecord.query.url");
    }

    public static String getWeboxTradeStatisUrl() {
        return ConfigurationUtils.getString("webox.tradeRecord.statis.url");
    }

    public static String getWeboxTradeRecordDeleteUrl() {
        return ConfigurationUtils.getString("webox.tradeRecord.delete.url");
    }

    public static String getWeboxBillQueryUrl() {
        return ConfigurationUtils.getString("webox.bill.query.url");
    }

    public static String getWeboxBillDetailQueryUrl() {
        return ConfigurationUtils.getString("webox.bill.detail.query.url");
    }

    public static String getWeboxRedPacketBillQueryUrl() {
        return ConfigurationUtils.getString("webox.redpacket.bill.query.url");
    }

    public static String getWeboxAccountHistoryQueryUrl() {
        return ConfigurationUtils.getString("webox.account.history.url");
    }

    public static String getWeboxRedPacketGrabHistoryUrl() {
        return ConfigurationUtils.getString("webox.redpacket.grab.history.url");
    }

    public static String getWeboxWalletSafeCreateToken() {
        return ConfigurationUtils.getString("webox.wallet.safe.create.token.url");
    }

    public static String getWeboxPayPasswordValidateCreate() {
        return ConfigurationUtils.getString("webox.pay.password.validate.create.url");
    }

    public static String getWeboxPayPasswordValidateQuery() {
        return ConfigurationUtils.getString("webox.pay.password.validate.query.url");
    }

    public static String getWeboxSilenceRescindCreate() {
        return ConfigurationUtils.getString("webox.silence.rescind.create.url");
    }

    public static String getWeboxSilenceRescindQuery() {
        return ConfigurationUtils.getString("webox.silence.rescind.query.url");
    }

    public static String getWeboxConnectPayCreateUrl() {
        return ConfigurationUtils.getString("webox.connectPay.create.url");
    }

    public static String getWeboxConnectPaySubmitUrl() {
        return ConfigurationUtils.getString("webox.connectPay.submit.url");
    }

    public static String getWeboxConnectPayQureyUrl() {
        return ConfigurationUtils.getString("webox.connectPay.query.url");
    }

    public static String getHttpContentEncoding() {
        return ConfigurationUtils.getString("http.content.type.encoding");
    }

    public static String getEshoppingHistoryConsumeUrl() {
        return ConfigurationUtils.getString("eshopping.getHistoryConsume.url");
    }

    public static String getEshoppingAvailableBalanceUrl() {
        return ConfigurationUtils.getString("eshopping.getAvailableBalance.url");
    }

    public static String getEshoppingMerchantListPriceUrl() {
        return ConfigurationUtils.getString("eshopping.getMerchantListPrice.url");
    }

    public static String getEasePayCreateOrderUrl() {
        return ConfigurationUtils.getString("easepay.create.order.url");
    }

    public static String getEshoppingMiddleMerchantApplyCardUrl() {
        return ConfigurationUtils.getString("eshopping.middle.merchant.applyVccCard.url");
    }

    public static String getEshoppingQueryMiddleMerchantApplyCardUrl() {
        return ConfigurationUtils.getString("eshopping.middle.merchant.queryApplyVccCard.url");
    }

    public static String getWeboxTradeStatUrl() {
        return ConfigurationUtils.getString("webox.trade.stat.url");
    }

    public static String getWeboxRedpacketTradeStatUrl() {
        return ConfigurationUtils.getString("webox.trade.redpacket.stat.url");
    }

    public static String getOldClientPrivateKeyPath(String merchantId) {
        return ConfigurationUtils.getString(merchantId + ".client.old.private.key.path");
    }

    public static String getOldClientPrivateKeyPassword(String merchantId) {
        return ConfigurationUtils.getString(merchantId + ".client.old.private.key.password");
    }

    public static String getServiceProviderDeclarationUrl() {
        return ConfigurationUtils.getString("serviceprovider.declaration.url");
    }

    public static String getServiceProviderPreDeclarationUrl() {
        return ConfigurationUtils.getString("serviceprovider.preDeclaration.url");
    }

    public static String getServiceProviderDeclarationQueryUrl() {
        return ConfigurationUtils.getString("serviceprovider.declaration.query.url");
    }

    public static String getServiceProviderDeclarationQueryInfoUrl() {
        return ConfigurationUtils.getString("serviceprovider.declaration.queryInfo.url");
    }

    public static String getServiceProviderReSendMsUrl() {
        return ConfigurationUtils.getString("serviceprovider.reSendMsg.url");
    }

    public static String getServiceProviderModifyBankCardUrl() {
        return ConfigurationUtils.getString("serviceprovider.modifyBankCard.url");
    }

    public static String getServiceProviderModifyBaseInfoUrl() {
        return ConfigurationUtils.getString("serviceprovider.modifyBaseInfo.url");
    }

    public static String getServiceProviderElectronicReSendUrl() {
        return ConfigurationUtils.getString("serviceprovider.electronicReSign.url");
    }

    public static String getServiceProviderWechatApiReportUrl() {
        return ConfigurationUtils.getString("serviceprovider.weChatApiReport.url");
    }

    public static String getServiceProviderAliPayApiReportUrl() {
        return ConfigurationUtils.getString("serviceprovider.aliPayApiReport.url");
    }

    public static String getServiceProviderWeChatConfigReportUrl() {
        return ConfigurationUtils.getString("serviceprovider.weChatConfigReport.url");
    }

    public static String getServiceProviderSubmitApplyUrl() {
        return ConfigurationUtils.getString("serviceprovider.submitApply.url");
    }

    public static String getServiceProviderQueryApplyStatusUrl() {
        return ConfigurationUtils.getString("serviceprovider.queryApplyStatus.url");
    }

    public static String getServiceProviderUndoApplyUrl() {
        return ConfigurationUtils.getString("serviceprovider.undoApply.url");
    }

    public static String getServiceProviderCUPApiReportUrl() {
        return ConfigurationUtils.getString("serviceprovider.cupApiReport.url");
    }

    public static String getServiceProviderTerminalReportUrl() {
        return ConfigurationUtils.getString("serviceprovider.terminalReport.url");
    }

    public static String getServiceProviderQuerySuccessSecondaryReportUrl() {
        return ConfigurationUtils.getString("serviceprovider.querySuccessSecondaryReport.url");
    }

    public static String getServiceProviderCustomElectronicSignUrl() {
        return ConfigurationUtils.getString("serviceprovider.customElectronicSign.url");
    }

    public static String getSubMerchantBalanceQueryUrl() {
        return ConfigurationUtils.getString("subMerchantBalanceQuery.url");
    }

    public static String getServiceProviderMerchantInfoChangeUrl() {
        return ConfigurationUtils.getString("serviceprovider.merchantInfoChange.url");
    }

    public static String getInterconnectionMerchantRegistrationUrl() {
        return ConfigurationUtils.getString("serviceprovider.interconnectionMerchantRegistration.url");
    }

    public static String getQueryInterconnectionInfoUrl() {
        return ConfigurationUtils.getString("serviceprovider.queryInterconnectionInfo.url");
    }

    public static String getConfigChangeUrl() {
        return ConfigurationUtils.getString("serviceprovider.configChange.url");
    }

    public static String getQueryConfigChangeUrl() {
        return ConfigurationUtils.getString("serviceprovider.configChange.query.url");
    }

    public static String getCpOnlinePayOrderUrl() {
        return ConfigurationUtils.getString("cp.onlinepay.order.url");
    }

    public static String getCpOnlinePayQueryUrl() {
        return ConfigurationUtils.getString("cp.onlinepay.query.url");
    }

    public static String getCpOnlinePayRefundUrl() {
        return ConfigurationUtils.getString("cp.onlinepay.refund.url");
    }

    public static String getCpOnlinePayRefundQueryUrl() {
        return ConfigurationUtils.getString("cp.onlinepay.refund.query.url");
    }

    public static String getCpOnlinePayCloseOrderUrl() {
        return ConfigurationUtils.getString("cp.onlinepay.close.order.url");
    }

    public static String getRemittanceOrderUrl() {
        return ConfigurationUtils.getString("remittance.order.url");
    }

    public static String getRemittanceQueryUrl() {
        return ConfigurationUtils.getString("remittance.query.url");
    }

    public static String getOverseasListPriceUrl() {
        return ConfigurationUtils.getString("overseas.bid.url");
    }

    public static String getSJTTransferOrderUrl() {
        return ConfigurationUtils.getString("sjtTransfer.order.url");
    }

    public static String getSJTTransferOrderConfirmUrl() {
        return ConfigurationUtils.getString("sjtTransfer.order.confirm.url");
    }

    public static String getSJTTransferOrderSendSmsUrl() {
        return ConfigurationUtils.getString("sjtTransfer.order.sendSms.url");
    }

    public static String getSJTTransferOrderQueryUrl() {
        return ConfigurationUtils.getString("sjtTransfer.order.query.url");
    }

    public static String getSJTTransferOrderVoucherUrl() {
        return ConfigurationUtils.getString("sjtTransfer.order.voucher.url");
    }

    public static String getWechatComplaintOrderQueryUrl() {
        return ConfigurationUtils.getString("wechat.complaint.order.query.url");
    }

    public static String getWechatComplaintNegotiationHistoryUrl() {
        return ConfigurationUtils.getString("wechat.complaint.negotiation.history.url");
    }

    public static String getWechatComplaintFeedbackUrl() {
        return ConfigurationUtils.getString("wechat.complaint.feedback.url");
    }

    public static String getOverseasAccountQueryUrl() {
        return ConfigurationUtils.getString("overseas.account.query.url");
    }

    public static String getForeignpayV3OrderUrl() {
        return ConfigurationUtils.getString("foreignpay.exchangesettlement.order");
    }

    public static String getForeignpayV3QueryUrl() {
        return ConfigurationUtils.getString("foreignpay.exchangesettlement.query");
    }

    public static String getOnlinePayOrderDemoMerchantId() {
        return ConfigurationUtils.getString("onlinepay.order.demo.merchant.id");
    }

    public static String getOnlinePayOrderDemoPaymentModeCode() {
        return ConfigurationUtils.getString("onlinepay.order.demo.paymentmode.code");
    }

    public static String getOnlinePayOrderDemoNotifyUrl(String merchantId) {
        return ConfigurationUtils.getString("onlinepay.order.demo.notify.url." + merchantId);
    }

    public static String getOnlinePayOrderDemoCallBackUrl(String merchantId) {
        return ConfigurationUtils.getString("onlinepay.order.demo.callBack.url." + merchantId);
    }

    public static String getSdkWeb() {
        return ConfigurationUtils.getString("sdk.web");
    }

    public static String getOceExchangeQueryQuote() {
        return ConfigurationUtils.getString("oce.exchange.query.quote.url");
    }

    public static String getOceExchangeConfirm() {
        return ConfigurationUtils.getString("oce.exchange.confirm.url");
    }

    public static String getOceQuoteInfo() {
        return ConfigurationUtils.getString("oce.exchange.quote.info.url");
    }

    public static String getOceAddWithdrawAccount() {
        return ConfigurationUtils.getString("oce.exchange.add.withdraw.account");
    }

    public static String getOceAddPaymentAccount() {
        return ConfigurationUtils.getString("oce.exchange.add.payment.account");
    }

    public static String getOceWithdrawAccountInfo() {
        return ConfigurationUtils.getString("oce.exchange.withdraw.account.info");
    }

    public static String getOcePaymentAccountInfo() {
        return ConfigurationUtils.getString("oce.exchange.payment.account.info");
    }

    public static String getOceCalculateFee() {
        return ConfigurationUtils.getString("oce.exchange.calculate.fee");
    }

    public static String getOceAccountBalance() {
        return ConfigurationUtils.getString("oce.exchange.account.balance");
    }

    public static String getOceWithdrawPay() {
        return ConfigurationUtils.getString("oce.exchange.withdraw.pay");
    }

    public static String getOceAccountFlow() {
        return ConfigurationUtils.getString("oce.exchange.account.flow");
    }

    public static String getOceAccountQuota() {
        return ConfigurationUtils.getString("oce.exchange.account.quota");
    }

    public static String getOceSettleDay() {
        return ConfigurationUtils.getString("oce.exchange.settleDay");
    }

    public static String getOcePaymentServiceFee() {
        return ConfigurationUtils.getString("oce.exchange.payment.service.fee");
    }

    public static String getOcePaymentOrderAuditUrl() {
        return ConfigurationUtils.getString("oce.exchange.payment.order.audit.url");
    }

    public static String getEhbMemberAuthUrl() {
        return ConfigurationUtils.getString("ehb.app.member.auth.url");
    }

    public static String getForeignExchangeRegisterUrl() {
        return ConfigurationUtils.getString("foreignexchange.register.proof.url");
    }

    public static String getForeignExchangeUploadGoodsTradeProofUrl() {
        return ConfigurationUtils.getString("foreignexchange.upload.goodsTrade.proof.url");
    }

    public static String getEnjoyMerchantAuthUrl() {
        return ConfigurationUtils.getString("enjoy.app.merchant.auth.url");
    }

    public static String getEnjoyMerchantCreateUrl() {
        return ConfigurationUtils.getString("enjoy.merchant.create.url");
    }

    public static String getEnjoyShopDeclareUrl() {
        return ConfigurationUtils.getString("enjoy.shop.declare.url");
    }

    public static String getEnjoyShopDeclareQueryUrl() {
        return ConfigurationUtils.getString("enjoy.shop.declare.query.url");
    }

    public static String getEnjoyShopReportChannelUrl() {
        return ConfigurationUtils.getString("enjoy.shop.report.channel.url");
    }

    public static String getEnjoyShopReportChannelQueryUrl() {
        return ConfigurationUtils.getString("enjoy.shop.report.channel.query.url");
    }

    public static String getEnjoyShopReportChannelIntentionUrl() {
        return ConfigurationUtils.getString("enjoy.shop.report.channel.intention.url");
    }

    public static String getEnjoyShopReportChannelUndoIntentionUrl() {
        return ConfigurationUtils.getString("enjoy.shop.report.channel.undo.intention.url");
    }

    public static String getEnjoyShopRateUpdateUrl() {
        return ConfigurationUtils.getString("enjoy.shop.rate.update.url");
    }

    public static String getEnjoyShopRateQueryUrl() {
        return ConfigurationUtils.getString("enjoy.shop.rate.query.url");
    }

    public static String getEnjoyPostReviewComplementUrl() {
        return ConfigurationUtils.getString("enjoy.shop.postReviewComplement.url");
    }

    public static String getEnjoyShopElectronicSignUrl() {
        return ConfigurationUtils.getString("enjoy.shop.electronicSign.url");
    }

    public static String getEnjoyMerchantBankCardSubmitUrl() {
        return ConfigurationUtils.getString("enjoy.merchant.bankCard.submit.url");
    }

    public static String getEnjoyMerchantBankCardSetDefaultUrl() {
        return ConfigurationUtils.getString("enjoy.merchant.bankCard.setDefault.url");
    }

    public static String getEnjoyMerchantBankCardUnbindUrl() {
        return ConfigurationUtils.getString("enjoy.merchant.bankCard.unbind.url");
    }

    public static String getEnjoyMerchantPayBankCardListUrl() {
        return ConfigurationUtils.getString("enjoy.merchant.payBankCard.queryList.url");
    }

    public static String getEnjoyMerchantWalletQueryUrl() {
        return ConfigurationUtils.getString("enjoy.merchant.wallet.query.url");
    }

    public static String getEnjoyMerchantWalletClientTokenCreateUrl() {
        return ConfigurationUtils.getString("enjoy.merchant.wallet.clientToken.create.url");
    }

    public static String getEnjoyMerchantWalletPasswordValidateCreateUrl() {
        return ConfigurationUtils.getString("enjoy.merchant.wallet.passwordValidate.create.url");
    }

    public static String getEnjoyMerchantWalletPasswordValidateQueryUrl() {
        return ConfigurationUtils.getString("enjoy.merchant.wallet.passwordValidate.query.url");
    }

    public static String getEnjoyMerchantWithdrawCreateUrl() {
        return ConfigurationUtils.getString("enjoy.merchant.withdraw.create.url");
    }

    public static String getEnjoyMerchantWithdrawQueryUrl() {
        return ConfigurationUtils.getString("enjoy.merchant.withdraw.query.url");
    }

    public static String getEnjoyTerminalBindUrl() {
        return ConfigurationUtils.getString("enjoy.terminal.bind.url");
    }

    public static String getEnjoyTerminalUnbindUrl() {
        return ConfigurationUtils.getString("enjoy.terminal.unbind.url");
    }

    public static String getEnjoyCashierReceiptGenerateUrl() {
        return ConfigurationUtils.getString("enjoy.cashier.receipt.generate.url");
    }

    public static String getEnjoyCashierTokenCreateUrl() {
        return ConfigurationUtils.getString("enjoy.cashier.token.create.url");
    }

    public static String getSettlementRecordQueryUrl() {
        return ConfigurationUtils.getString("settlement.record.query.url");
    }

    public static String getMemberSnapshotQueryUrl() {
        return ConfigurationUtils.getString("member.snapshot.query.url");
    }

    public static String getCloudLoginTicketUrl() {
        return ConfigurationUtils.getString("cloud.login.ticket.url");
    }

    public static String getDestroyTicketUrl() {
        return ConfigurationUtils.getString("cloud.destroy.ticket.url");
    }

    public static String getEnjoyCertificateExpireUpdateMerrchantIdCardUrl() {
        return ConfigurationUtils.getString("enjoy.certificate.expire.update.merchant.idcard.url");
    }

    public static String getEnjoyCertificateExpireUpdateShopBusinessUrl() {
        return ConfigurationUtils.getString("enjoy.certificate.expire.update.shop.business.url");
    }

    public static String getEnjoyMerchantWalletSilenceRescindUrl() {
        return ConfigurationUtils.getString("enjoy.merchant.wallet.silence.rescind.url");
    }

    public static String getDeclarationBorrowMerchantUrl() {
        return ConfigurationUtils.getString("serviceprovider.borrowMerchant.url");
    }

    public static String getMktDiscountApplyUrl() {
        return ConfigurationUtils.getString("mkt.discount.apply.url");
    }

    public static String getMktDiscountQueryUrl() {
        return ConfigurationUtils.getString("mkt.discount.query.url");
    }

    public static String getWechatOpenIdByJscode() {
        return ConfigurationUtils.getString("wechat.getopenid.by.jscode");
    }

    public static String getValue(String key) {
        String value = StringUtils.trim((String)Holder.config.getString(key));
        if (StringUtils.isBlank((CharSequence)value)) {
            LOGGER.warn("ConfigurationUtils.getString:[" + key + "] is blank");
        }
        return value;
    }

    private static class Holder {
        public static Configuration config;

        private Holder() {
        }

        static {
            try {
                if (!customSource) {
                    config = new PropertiesConfiguration(ConfigurationUtils.CONFIG_FILE);
                }
            }
            catch (ConfigurationException e) {
                LOGGER.error("classpath:ehking-config.properties not found", (Throwable)e);
            }
        }
    }
}

