/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.crypto.international.utils;

import com.upay.sdk.crypto.codec.Base64;
import java.io.ByteArrayOutputStream;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSAUtils {
    private static final int MAX_DECRYPT_BLOCK = 128;
    private static final String ENCODING = "UTF-8";
    private static final String RSA_ALGORITHM = "RSA/ECB/PKCS1Padding";
    static final Logger LOGGER = LoggerFactory.getLogger(RSAUtils.class);

    public static String sign(byte[] data, String privateKey) throws Exception {
        byte[] keyBytes = Base64.decode((CharSequence)privateKey);
        PKCS8EncodedKeySpec pkcs8EncodedKeySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PrivateKey privateKey2 = keyFactory.generatePrivate(pkcs8EncodedKeySpec);
        Signature signature = Signature.getInstance("MD5withRSA");
        signature.initSign(privateKey2);
        signature.update(data);
        return Base64.encode((byte[])signature.sign());
    }

    public static boolean verify(byte[] data, String publicKey, String sign) throws Exception {
        byte[] keyBytes = Base64.decode((CharSequence)publicKey);
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PublicKey publicKey2 = keyFactory.generatePublic(x509EncodedKeySpec);
        Signature signature = Signature.getInstance("MD5withRSA");
        signature.initVerify(publicKey2);
        signature.update(data);
        return signature.verify(Base64.decode((CharSequence)sign));
    }

    @Deprecated
    public static byte[] encryptSHA(byte[] data) throws Exception {
        return data;
    }

    public static Key getPublicKeyByString(String key) throws Exception {
        if (StringUtils.isBlank((CharSequence)key)) {
            LOGGER.error("key is null.");
        }
        byte[] keyBytes = Base64.decode((CharSequence)key);
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return keyFactory.generatePublic(x509EncodedKeySpec);
    }

    public static Key getPrivateKeyByString(String key) throws Exception {
        byte[] keyBytes = Base64.decode((CharSequence)key);
        PKCS8EncodedKeySpec pkcs8EncodedKeySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return keyFactory.generatePrivate(pkcs8EncodedKeySpec);
    }

    public static String decreptData(String content, String privateKey) throws Exception {
        return RSAUtils.decreptData(content, privateKey, ENCODING);
    }

    public static String decreptData(String content, String privateKey, String encoding) throws Exception {
        Cipher rsaCipher = null;
        int offSet2 = 0;
        byte[] cache2 = null;
        int i2 = 0;
        byte[] contentByte = Base64.decode((CharSequence)content);
        int inputLen2 = contentByte.length;
        ByteArrayOutputStream out2 = new ByteArrayOutputStream();
        rsaCipher = Cipher.getInstance(RSA_ALGORITHM);
        rsaCipher.init(2, RSAUtils.getPrivateKeyByString(privateKey));
        while (inputLen2 - offSet2 > 0) {
            cache2 = inputLen2 - offSet2 > 128 ? rsaCipher.doFinal(contentByte, offSet2, 128) : rsaCipher.doFinal(contentByte, offSet2, inputLen2 - offSet2);
            out2.write(cache2, 0, cache2.length);
            offSet2 = ++i2 * 128;
        }
        byte[] decryptedData2 = out2.toByteArray();
        out2.close();
        return new String(decryptedData2, encoding);
    }

    public static String encryptByPublicKey(String source, String publicKey) throws Exception {
        Key key = RSAUtils.getPublicKeyByString(publicKey);
        Cipher cipher = Cipher.getInstance(RSA_ALGORITHM);
        cipher.init(1, key);
        byte[] b = source.getBytes(ENCODING);
        byte[] b1 = cipher.doFinal(b);
        return Base64.encode((byte[])b1);
    }

    public static String decryptByPrivateKey(String cryptograph, String privateKey) throws Exception {
        Key key = RSAUtils.getPrivateKeyByString(privateKey);
        Cipher cipher = Cipher.getInstance(RSA_ALGORITHM);
        cipher.init(2, key);
        byte[] b1 = Base64.decode((CharSequence)cryptograph);
        byte[] b = cipher.doFinal(b1);
        return new String(b);
    }
}

