/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.crypto.international.spi;

import com.upay.sdk.crypto.CertificateReaderAdapter;
import com.upay.sdk.crypto.EncryptionAlgorithm;
import com.upay.sdk.crypto.codec.Base64;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateReaderImpl
extends CertificateReaderAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(CertificateReaderImpl.class);
    private static final String DEFAULT_PUBLIC_BASE64_KEY = "MIIELTCCAxWgAwIBAgIFEYIJd4IwDQYJKoZIhvcNAQEFBQAwITELMAkGA1UEBhMCQ04xEjAQBgNVBAoTCUNGQ0EgT0NBMTAeFw0xODA2MTkwODQzMjNaFw0yMzA2MTkwODQzMjNaMIGYMQswCQYDVQQGEwJDTjESMBAGA1UEChMJQ0ZDQSBPQ0ExMRAwDgYDVQQLEwdQYXlFYXNlMRkwFwYDVQQLExBPcmdhbml6YXRpb25hbC0xMUgwRgYDVQQDDD9QYXlFYXNlQOmmluS/oeaYk+aZuuS7mOenkeaKgOaWsOezu+e7n+a1i+ivlUA4MTEwMDAwNDEwMjc4NDQ3QDEwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDaf14KVZzB9c/V8Tkmz9tiIuUOyK7wZ5XTjdgpnJo4pzPE4MOj9baOCTyQxh2jHx3oAQetCeM+X/30um1DzB/bIiEfBN2cNJoyjV0Tozod98uUyTbJlz+1sHO6EQOSMIhQc5ZFXUF4Y5e2R4dDNtVk3IvVu0Ow8Hvo0a99fvMH5Z2ea3/yvdLIgPzZdliUwb0naDar/WWRW2caZhnagcMYHUW0T83Uszk9380ZB+HBOlOjSMrRYEpft/np17GkECwUdAUngIUCxFNVgbNFNFfowFPsDHfTTvh5PcXDtNW6oNGtDVuN7PSsM+M3qa2pJHLnkr1qFB8RsRm37QuUPM43AgMBAAGjgfMwgfAwHwYDVR0jBBgwFoAU0dvpiILl3RqPTKoAjL588qsb9tkwSAYDVR0gBEEwPzA9BghggRyG7yoBATAxMC8GCCsGAQUFBwIBFiNodHRwOi8vd3d3LmNmY2EuY29tLmNuL3VzL3VzLTE0Lmh0bTA4BgNVHR8EMTAvMC2gK6AphidodHRwOi8vY3JsLmNmY2EuY29tLmNuL1JTQS9jcmwxNTY0OC5jcmwwCwYDVR0PBAQDAgPoMB0GA1UdDgQWBBQXOY8jOBFb0MzeSHcxZtQAtEvo5DAdBgNVHSUEFjAUBggrBgEFBQcDAgYIKwYBBQUHAwQwDQYJKoZIhvcNAQEFBQADggEBAHlZK1eTyuUUq6txDCa+wyiTAGfUa+CkiXojw1p/y4G8hkJE+xNKiyY4fz5hQZ4fBq6iSca7Gdn29u8pkOsIfS1Hn4rAbgbPXL+EBOqj8s0T0OSVVkHeJLavt07ctL8XaoWE584ayJYfiYhn1AkJTjN6XyLpvfcWdwrXIrLeBGSLPy9CJlGfJ2adReR30KnJbUOV/vZaInvD11kOfKLhtoqVpU9aqu5h8srg2Xf4vrKFughxsDiFloXeJarWyy6XX4x3WFggKgSDwOPfyxx0EZOLp6FmEokZRqNdJCqIxo5LPt+ZYLJFRdlzvC0wDc8EA9QsFI8xaB+IHGvdJzCPzhM=";

    protected String parsePrivateKey(byte[] byteData, char[] password) {
        try {
            return CertificateReaderImpl.loadCertificateString(byteData, password);
        }
        catch (Exception e) {
            LOGGER.error("rsa parsePrivateKey error ", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    protected boolean canParsePrivateKey(byte[] byteData, char[] password) {
        try {
            CertificateReaderImpl.loadCertificateString(byteData, password);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected String parsePublicKey(byte[] byteData) {
        try {
            X509Certificate certificate = CertificateReaderImpl.parsePublicKeyCertificate(byteData);
            return Base64.encode((byte[])certificate.getPublicKey().getEncoded());
        }
        catch (Exception e) {
            LOGGER.error("rsa parsePublicKey error", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    protected String getDefaultPublicKey() {
        return this.parsePublicKey(Base64.decode((CharSequence)DEFAULT_PUBLIC_BASE64_KEY));
    }

    private static KeyStore loadCertificate(byte[] keyData, char[] password) throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException {
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(keyData);){
            KeyStore ks = KeyStore.getInstance("PKCS12");
            ks.load(inputStream, password);
            KeyStore keyStore = ks;
            return keyStore;
        }
    }

    private static String loadCertificateString(byte[] keyData, char[] password) throws CertificateException, IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        KeyStore ks = CertificateReaderImpl.loadCertificate(keyData, password);
        Enumeration<String> enumas = ks.aliases();
        String keyAlias = null;
        if (enumas.hasMoreElements()) {
            keyAlias = enumas.nextElement();
        }
        PrivateKey privateKey = (PrivateKey)ks.getKey(keyAlias, password);
        return Base64.encode((byte[])privateKey.getEncoded());
    }

    private static X509Certificate parsePublicKeyCertificate(byte[] keyData) throws IOException, CertificateException {
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(keyData);){
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(inputStream);
            return x509Certificate;
        }
    }

    public EncryptionAlgorithm getEncryptionAlgorithm() {
        return EncryptionAlgorithm.INTERNATIONAL_ALGORITHM;
    }
}

