/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.crypto.sm.crypto.digest.mac;

import com.upay.sdk.crypto.exception.CryptoException;
import com.upay.sdk.crypto.sm.crypto.SecureUtil;
import com.upay.sdk.crypto.sm.crypto.digest.mac.MacEngine;
import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class DefaultHMacEngine
implements MacEngine {
    private Mac mac;

    public DefaultHMacEngine(String algorithm, Key key, AlgorithmParameterSpec spec) {
        this.init(algorithm, key, spec);
    }

    public DefaultHMacEngine init(String algorithm, byte[] key) {
        return this.init(algorithm, null == key ? null : new SecretKeySpec(key, algorithm));
    }

    public DefaultHMacEngine init(String algorithm, Key key) {
        return this.init(algorithm, key, null);
    }

    public DefaultHMacEngine init(String algorithm, Key key, AlgorithmParameterSpec spec) {
        try {
            this.mac = SecureUtil.createMac(algorithm);
            if (null == key) {
                key = SecureUtil.generateKey(algorithm);
            }
            if (null != spec) {
                this.mac.init(key, spec);
            } else {
                this.mac.init(key);
            }
        }
        catch (Exception e) {
            throw new CryptoException((Throwable)e);
        }
        return this;
    }

    public Mac getMac() {
        return this.mac;
    }

    @Override
    public void update(byte[] in) {
        this.mac.update(in);
    }

    @Override
    public void update(byte[] in, int inOff, int len) {
        this.mac.update(in, inOff, len);
    }

    @Override
    public byte[] doFinal() {
        return this.mac.doFinal();
    }

    @Override
    public void reset() {
        this.mac.reset();
    }

    @Override
    public byte[] digest(InputStream data, int bufferLength) {
        byte[] result;
        if (bufferLength < 1) {
            bufferLength = 8192;
        }
        byte[] buffer = new byte[bufferLength];
        try {
            int read = data.read(buffer, 0, bufferLength);
            while (read > -1) {
                this.update(buffer, 0, read);
                read = data.read(buffer, 0, bufferLength);
            }
            result = this.doFinal();
        }
        catch (IOException e) {
            throw new CryptoException((Throwable)e);
        }
        finally {
            this.reset();
        }
        return result;
    }

    @Override
    public int getMacLength() {
        return this.mac.getMacLength();
    }

    @Override
    public String getAlgorithm() {
        return this.mac.getAlgorithm();
    }
}

