/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.crypto.sm.crypto.digest.mac;

import com.upay.sdk.crypto.exception.CryptoException;
import com.upay.sdk.crypto.sm.crypto.digest.mac.MacEngine;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.Mac;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;

public class BCHMacEngine
implements MacEngine {
    private Mac mac;

    public BCHMacEngine(Digest digest, byte[] key) {
        this(digest, (CipherParameters)new KeyParameter(key));
    }

    public BCHMacEngine(Digest digest, CipherParameters params) {
        this.init(digest, params);
    }

    public BCHMacEngine init(Digest digest, CipherParameters params) {
        this.mac = new HMac(digest);
        this.mac.init(params);
        return this;
    }

    public Mac getMac() {
        return this.mac;
    }

    @Override
    public void update(byte[] in) {
        this.update(in, 0, in.length);
    }

    @Override
    public void update(byte[] in, int inOff, int len) {
        this.mac.update(in, inOff, len);
    }

    @Override
    public byte[] doFinal() {
        byte[] result = new byte[this.getMacLength()];
        this.mac.doFinal(result, 0);
        return result;
    }

    @Override
    public void reset() {
        this.mac.reset();
    }

    @Override
    public byte[] digest(InputStream data, int bufferLength) {
        byte[] result;
        if (bufferLength < 1) {
            bufferLength = 8192;
        }
        byte[] buffer = new byte[bufferLength];
        try {
            int read = data.read(buffer, 0, bufferLength);
            while (read > -1) {
                this.update(buffer, 0, read);
                read = data.read(buffer, 0, bufferLength);
            }
            result = this.doFinal();
        }
        catch (IOException e) {
            throw new CryptoException((Throwable)e);
        }
        finally {
            this.reset();
        }
        return result;
    }

    @Override
    public int getMacLength() {
        return this.mac.getMacSize();
    }

    @Override
    public String getAlgorithm() {
        return this.mac.getAlgorithmName();
    }
}

