/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.crypto.sm.crypto;

import com.upay.sdk.crypto.sm.crypto.BCUtil;
import com.upay.sdk.crypto.sm.crypto.asymmetric.SM2;
import com.upay.sdk.crypto.sm.crypto.digest.HMac;
import com.upay.sdk.crypto.sm.crypto.digest.HmacAlgorithm;
import com.upay.sdk.crypto.sm.crypto.digest.SM3;
import com.upay.sdk.crypto.sm.crypto.digest.mac.BCHMacEngine;
import com.upay.sdk.crypto.sm.crypto.digest.mac.MacEngine;
import com.upay.sdk.crypto.sm.crypto.symmetric.SM4;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.bouncycastle.asn1.gm.GMNamedCurves;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;

public class SmUtil {
    public static final String SM2_CURVE_NAME = "sm2p256v1";
    public static final ECDomainParameters SM2_DOMAIN_PARAMS = BCUtil.toDomainParams(GMNamedCurves.getByName((String)"sm2p256v1"));

    public static SM2 sm2() {
        return new SM2();
    }

    public static SM2 sm2(String privateKeyStr, String publicKeyStr) {
        return new SM2(privateKeyStr, publicKeyStr);
    }

    public static SM2 sm2(byte[] privateKey, byte[] publicKey) {
        return new SM2(privateKey, publicKey);
    }

    public static SM2 sm2(PrivateKey privateKey, PublicKey publicKey) {
        return new SM2(privateKey, publicKey);
    }

    public static SM2 sm2(ECPrivateKeyParameters privateKeyParams, ECPublicKeyParameters publicKeyParams) {
        return new SM2(privateKeyParams, publicKeyParams);
    }

    public static SM3 sm3() {
        return new SM3();
    }

    public static String sm3(String data) {
        return SmUtil.sm3().digestHex(data);
    }

    public static String sm3(InputStream data) {
        return SmUtil.sm3().digestHex(data);
    }

    public static String sm3(File dataFile) throws FileNotFoundException {
        return SmUtil.sm3().digestHex(dataFile);
    }

    public static SM4 sm4() {
        return new SM4();
    }

    public static SM4 sm4(byte[] key) {
        return new SM4(key);
    }

    public static byte[] changeC1C2C3ToC1C3C2(byte[] c1c2c3, ECDomainParameters ecDomainParameters) {
        int c1Len = (ecDomainParameters.getCurve().getFieldSize() + 7) / 8 * 2 + 1;
        int c3Len = 32;
        byte[] result = new byte[c1c2c3.length];
        System.arraycopy(c1c2c3, 0, result, 0, c1Len);
        System.arraycopy(c1c2c3, c1c2c3.length - 32, result, c1Len, 32);
        System.arraycopy(c1c2c3, c1Len, result, c1Len + 32, c1c2c3.length - c1Len - 32);
        return result;
    }

    public static byte[] changeC1C3C2ToC1C2C3(byte[] c1c3c2, ECDomainParameters ecDomainParameters) {
        int c1Len = (ecDomainParameters.getCurve().getFieldSize() + 7) / 8 * 2 + 1;
        int c3Len = 32;
        byte[] result = new byte[c1c3c2.length];
        System.arraycopy(c1c3c2, 0, result, 0, c1Len);
        System.arraycopy(c1c3c2, c1Len + 32, result, c1Len, c1c3c2.length - c1Len - 32);
        System.arraycopy(c1c3c2, c1Len, result, c1c3c2.length - 32, 32);
        return result;
    }

    public static MacEngine createHmacSm3Engine(byte[] key) {
        return new BCHMacEngine((Digest)new SM3Digest(), key);
    }

    public static HMac hmacSm3(byte[] key) {
        return new HMac(HmacAlgorithm.HmacSM3, key);
    }
}

