package com.upay.sdk.wallet;

import com.alibaba.fastjson.JSONObject;


import com.upay.sdk.entity.Pointer;
import com.upay.sdk.exception.HmacVerifyException;
import com.upay.sdk.exception.RequestException;
import com.upay.sdk.exception.ResponseException;
import com.upay.sdk.exception.UnknownException;
import com.upay.sdk.executer.ResultListenerAdpater;
import com.upay.sdk.wallet.builder.WithdrawBuilder;
import com.upay.sdk.wallet.executer.WithdrawExecuter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;

/**
   二级商户提现
 */
public class WithdrawServlet extends HttpServlet {

	static final Logger LOGGER = LoggerFactory.getLogger(WithdrawServlet.class);
	private static final long serialVersionUID = 64861175881976489L;

	@Override
	protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
		doPost(req, resp);
	}

	@Override
	protected void doPost(final HttpServletRequest req,final HttpServletResponse resp) throws ServletException, IOException {
		String merchantId = req.getParameter("merchantId");
		String requestId = req.getParameter("requestId");
		String partnerId = req.getParameter("partnerId");
		String withdrawAmount = req.getParameter("withdrawAmount");
		String notifyUrl = req.getParameter("notifyUrl");
		String remark = req.getParameter("remark");
		String deputeMark = req.getParameter("deputeMark");
		String receivedAmount = req.getParameter("receivedAmount");
		String lng = req.getParameter("lng");
		String lat = req.getParameter("lat");
		Pointer location = new Pointer();
		location.setLng(lng);
		location.setLat(lat);

		WithdrawBuilder builder = new WithdrawBuilder(merchantId);
		builder.setRequestId(requestId)
				.setPartnerId(partnerId)
				.setWithdrawAmount(withdrawAmount)
				.setNotifyUrl(notifyUrl)
				.setRemark(remark)
				.setDeputeMark(deputeMark)
				.setReceivedAmount(receivedAmount);
		builder.setLocation(location);
		final PrintWriter out = resp.getWriter();

		WithdrawExecuter executer = new WithdrawExecuter();



		try {
			executer.bothWithdraw(builder, new ResultListenerAdpater() {
				@Override
				public void success(JSONObject jsonObject) {
					out.println("请求成功！<br/>");
					String result = jsonObject.toJSONString();
					out.print(result);
				}

				@Override
				public void failure(JSONObject jsonObject) {
					out.println("处理失败！<br/>");
					String result = jsonObject.toJSONString();
					out.print(result);
				}

				@Override
				public void pending(JSONObject jsonObject) {
					out.println("待处理！<br/>");
					String result = jsonObject.toJSONString();
					out.print(result);
				}
			});
		} catch (ResponseException e) {
			out.println("响应异常</br>");
			out.println(e.toString());
		} catch (HmacVerifyException e) {
			out.println("签名验证异常</br>");
			out.println(e.toString());
		} catch (RequestException e) {
			out.println("请求异常</br>");
			out.println(e.toString());
		} catch (UnknownException e) {
			out.println("未知异常</br>");
			out.println(e.toString());
		}
	}
}
