package com.upay.sdk.wallet;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.exception.HmacVerifyException;
import com.upay.sdk.exception.RequestException;
import com.upay.sdk.exception.ResponseException;
import com.upay.sdk.exception.UnknownException;
import com.upay.sdk.executer.ResultListenerAdpater;
import com.upay.sdk.wallet.builder.GenerateWithdrawVoucherBuilder;
import com.upay.sdk.wallet.executer.WithdrawExecuter;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 商户提现凭证接口
 */
public class WithdrawCertificateServlet extends HttpServlet {

    static final Logger LOGGER = LoggerFactory.getLogger(WithdrawCertificateServlet.class);
    private static final long serialVersionUID = 7259807085390578384L;

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        doPost(req, resp);
    }

    @Override
    protected void doPost(final HttpServletRequest req, final HttpServletResponse resp) throws ServletException, IOException {
        String merchantId = req.getParameter("merchantId");
        String orderId = req.getParameter("orderId");
        String partnerId = req.getParameter("partnerId");

        GenerateWithdrawVoucherBuilder builder = new GenerateWithdrawVoucherBuilder(merchantId);
        builder.setRequestId(orderId)
                .setPartnerId(partnerId);
        final PrintWriter out = resp.getWriter();

        WithdrawExecuter executer = new WithdrawExecuter();
        try {
            executer.generateWithdraw(builder, new ResultListenerAdpater() {
                @Override
                public void success(JSONObject jsonObject) {
                    out.println("请求成功！<br/>");
                    String result = jsonObject.toJSONString();
                    out.print(result);
                }

                @Override
                public void failure(JSONObject jsonObject) {
                    out.println("处理失败！<br/>");
                    String result = jsonObject.toJSONString();
                    out.print(result);
                }

                @Override
                public void pending(JSONObject jsonObject) {
                    out.println("待处理！<br/>");
                    String result = jsonObject.toJSONString();
                    out.print(result);
                }

            });
        } catch (ResponseException e) {
            out.println("响应异常</br>");
            out.println(e.toString());
        } catch (HmacVerifyException e) {
            out.println("签名验证异常</br>");
            out.println(e.toString());
        } catch (RequestException e) {
            out.println("请求异常</br>");
            out.println(e.toString());
        } catch (UnknownException e) {
            out.println("未知异常</br>");
            out.println(e.toString());
        }
    }
}
