/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.webox.builder;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.exception.UnknownException;

public final class TransferConfirmBuilder
extends BuilderSupport {
    private String merchantId;
    private String serialNumber;
    private String targetWalletId;

    public TransferConfirmBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public TransferConfirmBuilder setMerchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    public TransferConfirmBuilder setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
        return this;
    }

    public void setTargetWalletId(String targetWalletId) {
        this.targetWalletId = targetWalletId;
    }

    public JSONObject encryptBuild() {
        JSONObject json = super.assembleBuild();
        json.put("hmac", (Object)this.orderGenerateHmac());
        return CipherWrapper.encryptWrap(this.merchantId, json);
    }

    @Override
    protected String orderGenerateHmac() {
        String orderGenerateHmac = super.orderGenerateHmac();
        return SignUtils.signMd5(orderGenerateHmac, ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }
}

