/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.webox.builder;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.entity.ProductDetail;
import com.upay.sdk.exception.UnknownException;
import java.util.LinkedList;
import java.util.List;

public final class OnlinePayCreateBuilder
extends BuilderSupport {
    private String merchantId;
    private String requestId;
    private String walletId;
    private String amount;
    private String currency;
    private String notifyUrl;
    private String timeout;
    private String requestIp;
    private String productInfo;
    private String callbackUrl;
    private String wakeUpModel;
    private List<ProductDetail> productDetails = new LinkedList<ProductDetail>();

    public OnlinePayCreateBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public OnlinePayCreateBuilder setMerchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    public OnlinePayCreateBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public OnlinePayCreateBuilder setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
        return this;
    }

    public OnlinePayCreateBuilder setWalletId(String walletId) {
        this.walletId = walletId;
        return this;
    }

    public OnlinePayCreateBuilder setAmount(String amount) {
        this.amount = amount;
        return this;
    }

    public OnlinePayCreateBuilder setCurrency(String currency) {
        this.currency = currency;
        return this;
    }

    public OnlinePayCreateBuilder addProductDetail(ProductDetail productDetail) {
        this.productDetails.add(productDetail);
        return this;
    }

    public OnlinePayCreateBuilder setTimeout(String timeout) {
        this.timeout = timeout;
        return this;
    }

    public OnlinePayCreateBuilder setRequestIp(String requestIp) {
        this.requestIp = requestIp;
        return this;
    }

    public OnlinePayCreateBuilder setProductInfo(String productInfo) {
        this.productInfo = productInfo;
        return this;
    }

    public OnlinePayCreateBuilder setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
        return this;
    }

    public OnlinePayCreateBuilder setWakeUpModel(String wakeUpModel) {
        this.wakeUpModel = wakeUpModel;
        return this;
    }

    public JSONObject encryptBuild() {
        JSONObject json = super.assembleBuild();
        json.put("hmac", (Object)this.orderGenerateHmac());
        return CipherWrapper.encryptWrap(this.merchantId, json);
    }

    @Override
    protected String orderGenerateHmac() {
        String orderGenerateHmac = super.orderGenerateHmac();
        return SignUtils.signMd5(orderGenerateHmac, ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }
}

