/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.webox.builder;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.exception.UnknownException;

public final class MerchantRechargeBuilder
extends BuilderSupport {
    private String merchantId;
    private String partnerId;
    private String requestId;
    private String walletId;
    private String amount;
    private String currency;
    private String notifyUrl;
    private String remark;

    public MerchantRechargeBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public MerchantRechargeBuilder setMerchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    public MerchantRechargeBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public MerchantRechargeBuilder setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
        return this;
    }

    public MerchantRechargeBuilder setWalletId(String walletId) {
        this.walletId = walletId;
        return this;
    }

    public MerchantRechargeBuilder setAmount(String amount) {
        this.amount = amount;
        return this;
    }

    public MerchantRechargeBuilder setCurrency(String currency) {
        this.currency = currency;
        return this;
    }

    public MerchantRechargeBuilder setRemark(String remark) {
        this.remark = remark;
        return this;
    }

    public MerchantRechargeBuilder setPartnerId(String partnerId) {
        this.partnerId = partnerId;
        return this;
    }

    public JSONObject encryptBuild() {
        JSONObject json = super.assembleBuild();
        json.put("hmac", (Object)this.orderGenerateHmac());
        return CipherWrapper.encryptWrap(this.merchantId, json);
    }

    @Override
    protected String orderGenerateHmac() {
        String orderGenerateHmac = super.orderGenerateHmac();
        return SignUtils.signMd5(orderGenerateHmac, ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, this.partnerId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }
}

