/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.transferDomestic.executer;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.Constants;
import com.upay.sdk.HttpClientUtils;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.exception.ResponseException;
import com.upay.sdk.exception.UnknownException;
import com.upay.sdk.executer.Executer;
import com.upay.sdk.executer.ResultListener;
import com.upay.sdk.transferDomestic.builder.BatchOrderBuilder;
import com.upay.sdk.transferDomestic.builder.GenerateTransferVoucherBuilder;
import com.upay.sdk.transferDomestic.builder.OrderBuilder;
import com.upay.sdk.transferDomestic.builder.QueryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransferDomesticOrderExecuter
extends Executer {
    static final Logger LOGGER = LoggerFactory.getLogger(TransferDomesticOrderExecuter.class);
    static final String[] ORDER_RESPONSE_HMAC_FIELDS = new String[]{Constants.MERCHANT_ID, Constants.REQUEST_ID, Constants.STATUS};
    static final Object[] QUERY_RESPONSE_HMAC_FIELDS = new Object[]{Constants.MERCHANT_ID, Constants.REQUEST_ID, "remitRequestId", Constants.SERIAL_NUMBER, "amount", "currency", Constants.STATUS, "completeDateTime", "remark"};

    public void order(JSONObject requestData, ResultListener resultListener) {
        LOGGER.debug("requestData:[" + requestData.toJSONString() + "],transferDomesticOrderUrl:[" + ConfigurationUtils.getTransferDomesticOrderUrl() + "]");
        String responseStr = HttpClientUtils.post(ConfigurationUtils.getTransferDomesticOrderUrl(), requestData.toJSONString());
        LOGGER.debug("responseStr:[" + responseStr + "]");
        JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
        this.verifyHmac(ORDER_RESPONSE_HMAC_FIELDS, responseData);
        if (!Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
            throw new ResponseException(responseData);
        }
        resultListener.success(responseData);
    }

    public void callback(JSONObject responseData, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.verifyHmac(QUERY_RESPONSE_HMAC_FIELDS, responseData);
        String status = responseData.getString(Constants.STATUS);
        if (status != null && !status.equals("")) {
            if (Constants.SUCCESS.equals(status)) {
                listener.success(responseData);
            } else if (Constants.FAILED.equals(status) || Constants.CANCEL.equals(status)) {
                listener.failure(responseData);
            } else if (Constants.INIT.equals(status)) {
                listener.pending(responseData);
            } else if ("REMITING".equals(status)) {
                listener.pending(responseData);
            } else {
                throw new ResponseException(responseData);
            }
        }
    }

    public void query(JSONObject requestData, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        try {
            LOGGER.debug("requestData:[" + requestData.toJSONString() + "]");
            String responseStr = HttpClientUtils.post(ConfigurationUtils.getTransferDomesticQueryUrl(), requestData.toJSONString());
            LOGGER.debug("responseStr:[" + responseStr + "]");
            JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
            this.callback(responseData, listener);
        }
        catch (Exception e) {
            LOGGER.error("request order exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }

    public void order(OrderBuilder builder, ResultListener resultListener) {
        JSONObject requestData = builder.encryptBuild();
        LOGGER.debug("TransferDomesticOrderExecuter orderV_2 requestData:[" + requestData.toJSONString() + "],transferDomesticOrderUrl:[" + ConfigurationUtils.getTransferDomesticOrderUrl() + "]");
        String responseStr = HttpClientUtils.post2(ConfigurationUtils.getTransferDomesticOrderUrl(), requestData);
        LOGGER.debug("TransferDomesticOrderExecuter orderV_2 responseStr:[" + responseStr + "]");
        JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
        String status = responseData.getString(Constants.STATUS);
        if (Constants.ERROR.equals(status)) {
            throw new ResponseException(responseData);
        }
        responseData = CipherWrapper.decryptWrap(responseData);
        LOGGER.debug("responseStr:[" + responseData + "]");
        this.verifyHmacOrder(responseData);
        if (!Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
            throw new ResponseException(responseData);
        }
        resultListener.success(responseData);
    }

    public void query(QueryBuilder builder, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        try {
            JSONObject requestData = builder.encryptBuild();
            LOGGER.debug("TransferDomesticOrderExecuter queryV_2 requestData:[" + requestData + "]");
            String responseStr = HttpClientUtils.post2(ConfigurationUtils.getTransferDomesticQueryUrl(), requestData);
            JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
            String status = responseData.getString(Constants.STATUS);
            if (Constants.ERROR.equals(status)) {
                LOGGER.debug("TransferDomesticOrderExecuter queryV_2 decrypt responseData : {}", (Object)responseData);
                throw new ResponseException(responseData);
            }
            LOGGER.debug("TransferDomesticOrderExecuter queryV_2 responseStr:[" + responseStr + "]");
            this.cipherCallback(responseData, listener);
        }
        catch (Exception e) {
            LOGGER.error("request order exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }

    public void cipherCallback(JSONObject responseData, ResultListener listener) {
        LOGGER.info("TransferDomesticOrderExecuter cipherCallback responseData:[" + responseData + "]");
        if (listener == null) {
            throw new NullPointerException();
        }
        JSONObject data = CipherWrapper.decryptWrap(responseData);
        LOGGER.info("TransferDomesticOrderExecuter cipherCallback data:[" + data + "]");
        this.verifyHmacOrder(data);
        String status = data.getString(Constants.STATUS);
        LOGGER.info("TransferDomesticOrderExecuter cipherCallback status:[" + status + "]");
        if (status != null && !status.equals("")) {
            if (Constants.SUCCESS.equals(status)) {
                listener.success(data);
            } else if (Constants.FAILED.equals(status) || Constants.CANCEL.equals(status)) {
                listener.failure(data);
            } else if (Constants.INIT.equals(status)) {
                listener.pending(data);
            } else if ("REMITING".equals(status)) {
                listener.pending(data);
            } else {
                throw new ResponseException(data);
            }
        }
    }

    public void bothOrder(OrderBuilder builder, ResultListener resultListener) {
        JSONObject requestData = builder.bothEncryptBuild();
        LOGGER.debug("TransferDomesticOrderExecuter orderV_3 requestData:[" + requestData.toJSONString() + "],transferDomesticOrderUrl:[" + ConfigurationUtils.getTransferDomesticOrderUrl() + "]");
        String responseStr = HttpClientUtils.post3(ConfigurationUtils.getTransferDomesticOrderUrl(), requestData);
        LOGGER.debug("TransferDomesticOrderExecuter orderV_3 responseStr:[" + responseStr + "]");
        JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
        String status = responseData.getString(Constants.STATUS);
        if (Constants.ERROR.equals(status)) {
            throw new ResponseException(responseData);
        }
        responseData = CipherWrapper.bothDecryptWrap(responseData);
        LOGGER.debug("responseStr:[" + responseData + "]");
        this.bothVerifyHmacOrder(responseData);
        if (!Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
            throw new ResponseException(responseData);
        }
        resultListener.success(responseData);
    }

    public void batchBothOrder(BatchOrderBuilder builder, ResultListener resultListener) {
        JSONObject requestData = builder.bothEncryptBuild();
        LOGGER.debug("TransferDomesticOrderExecuter orderV_3 requestData:[" + requestData.toJSONString() + "],transferDomesticOrderUrl:[" + ConfigurationUtils.getTransferDomesticOrderUrl() + "]");
        String responseStr = HttpClientUtils.post3(ConfigurationUtils.getTransferDomesticBatchOrderUrl(), requestData);
        LOGGER.debug("TransferDomesticOrderExecuter orderV_3 responseStr:[" + responseStr + "]");
        JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
        String status = responseData.getString(Constants.STATUS);
        if (Constants.ERROR.equals(status)) {
            throw new ResponseException(responseData);
        }
        responseData = CipherWrapper.bothDecryptWrap(responseData);
        LOGGER.debug("responseStr:[" + responseData + "]");
        this.bothVerifyHmacOrder(responseData);
        if (!Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
            throw new ResponseException(responseData);
        }
        resultListener.success(responseData);
    }

    public void bothQuery(QueryBuilder builder, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        try {
            JSONObject requestData = builder.bothEncryptBuild();
            LOGGER.debug("TransferDomesticOrderExecuter queryV_3 requestData:[" + requestData + "]");
            String responseStr = HttpClientUtils.post3(ConfigurationUtils.getTransferDomesticQueryUrl(), requestData);
            JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
            String status = responseData.getString(Constants.STATUS);
            if (Constants.ERROR.equals(status)) {
                LOGGER.debug("TransferDomesticOrderExecuter queryV_3 decrypt responseData : {}", (Object)responseData);
                throw new ResponseException(responseData);
            }
            LOGGER.debug("TransferDomesticOrderExecuter queryV_3 responseStr:[" + responseStr + "]");
            this.bothCipherCallback(responseData, listener);
        }
        catch (Exception e) {
            LOGGER.error("request order exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }

    public void bothGenerateTransferVoucher(GenerateTransferVoucherBuilder builder, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        try {
            JSONObject requestData = builder.bothEncryptBuild();
            LOGGER.debug("TransferDomesticOrderExecuter generateTransferVoucherV_3 requestData:[" + requestData + "]");
            String responseStr = HttpClientUtils.post3(ConfigurationUtils.getTransferDomesticGenerateTransferVoucherUrl(), requestData);
            JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
            String status = responseData.getString(Constants.STATUS);
            if (Constants.ERROR.equals(status)) {
                LOGGER.debug("TransferDomesticOrderExecuter generateTransferVoucherV_3 decrypt responseData : {}", (Object)responseData);
                throw new ResponseException(responseData);
            }
            LOGGER.debug("TransferDomesticOrderExecuter generateTransferVoucherV_3 responseStr:[" + responseStr + "]");
            this.bothCipherCallback(responseData, listener);
        }
        catch (Exception e) {
            LOGGER.error("request order exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }

    public void bothCipherCallback(JSONObject responseData, ResultListener listener) {
        LOGGER.info("TransferDomesticOrderExecuter bothCipherCallback responseData:[" + responseData + "]");
        if (listener == null) {
            throw new NullPointerException();
        }
        JSONObject data = CipherWrapper.bothDecryptWrap(responseData);
        LOGGER.info("TransferDomesticOrderExecuter bothCipherCallback data:[" + data + "]");
        this.bothVerifyHmacOrder(data);
        String status = data.getString(Constants.STATUS);
        LOGGER.info("TransferDomesticOrderExecuter bothCipherCallback status:[" + status + "]");
        if (status != null && !status.equals("")) {
            if (Constants.SUCCESS.equals(status)) {
                listener.success(data);
            } else if (Constants.FAILED.equals(status) || Constants.CANCEL.equals(status)) {
                listener.failure(data);
            } else if (Constants.INIT.equals(status)) {
                listener.pending(data);
            } else if ("REMITING".equals(status)) {
                listener.pending(data);
            } else {
                throw new ResponseException(data);
            }
        }
    }
}

