/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.serviceprovider.v3_0.declaration.executer;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.Constants;
import com.upay.sdk.HttpClientUtils;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.exception.ResponseException;
import com.upay.sdk.exception.UnknownException;
import com.upay.sdk.executer.Executer;
import com.upay.sdk.executer.ResultListener;
import com.upay.sdk.serviceprovider.v3_0.declaration.builder.ConfigChangeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigChangeExecuter
extends Executer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigChangeExecuter.class);

    public void configChange(ConfigChangeBuilder builder, ResultListener resultListener) {
        block5: {
            try {
                JSONObject requestData = builder.bothEncryptBuild();
                LOGGER.debug("ConfigChangeExecuter requestData:[" + requestData.toJSONString() + "]");
                String responseStr = HttpClientUtils.post3(ConfigurationUtils.getConfigChangeUrl(), requestData);
                LOGGER.info("ConfigChangeExecuter responseStr:[" + responseStr + "]");
                JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
                responseData = CipherWrapper.bothDecryptWrap(responseData);
                LOGGER.info("ConfigChangeExecuter responseData:[" + responseData + "]");
                String status = responseData.getString(Constants.STATUS);
                if (Constants.ERROR.equals(status)) {
                    throw new ResponseException(responseData);
                }
                this.bothVerifyHmacOrder(responseData);
                if (Constants.SUCCESS.equals(status)) {
                    resultListener.success(responseData);
                    break block5;
                }
                if (Constants.FAILED.equals(status)) {
                    resultListener.failure(responseData);
                    break block5;
                }
                throw new ResponseException(responseData);
            }
            catch (Exception e) {
                LOGGER.error("ConfigChangeExecuter error", (Throwable)e);
                throw new UnknownException(e);
            }
        }
    }

    public void callBack(JSONObject responseData, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        LOGGER.info("configChange callBack responseStr:[" + responseData + "]");
        JSONObject data = CipherWrapper.bothDecryptWrap(responseData);
        LOGGER.info("configChange callBack responseData:[" + data + "]");
        this.bothVerifyHmacOrder(data);
        listener.success(data);
    }
}

