/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.serviceprovider.v3_0.declaration.builder;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.exception.UnknownException;

public class ModifyBaseInfoBuilder
extends BuilderSupport {
    private String merchantId;
    private String requestId;
    private String signedRequestId;
    private String subMerchantId;
    private String signedShorthand;
    private String businessAddressProvince;
    private String businessAddressCity;
    private String businessAddressArea;
    private String businessAddress;
    private String contactName;
    private String contactEmail;
    private String contactPhone;
    private String modifyType;
    private String businessLicensePath;
    private String openAccountPath;
    private String legalIdCardProsPath;
    private String legalIdCardConsPath;
    private String desireAuthPath;
    private String desireAuthOtherPath;
    private String holdingIdCardPath;
    private String webSitePath;
    private String wechatAppletPath;
    private String appPath;
    private String legalPersonBankCardPath;
    private String otherCerPath;
    private String storeHeaderPath;
    private String storeIndoorPath;

    public ModifyBaseInfoBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    @Override
    protected String orderGenerateHmac() {
        String orderGenerateHmac = super.orderGenerateHmac();
        String hmacKey = ConfigurationUtils.getHmacKey(this.merchantId);
        return SignUtils.signMd5(orderGenerateHmac, hmacKey);
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }

    public String getMerchantId() {
        return this.merchantId;
    }

    public void setMerchantId(String merchantId) {
        this.merchantId = merchantId;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public String getSignedRequestId() {
        return this.signedRequestId;
    }

    public void setSignedRequestId(String signedRequestId) {
        this.signedRequestId = signedRequestId;
    }

    public String getSubMerchantId() {
        return this.subMerchantId;
    }

    public void setSubMerchantId(String subMerchantId) {
        this.subMerchantId = subMerchantId;
    }

    public String getSignedShorthand() {
        return this.signedShorthand;
    }

    public void setSignedShorthand(String signedShorthand) {
        this.signedShorthand = signedShorthand;
    }

    public String getBusinessAddressProvince() {
        return this.businessAddressProvince;
    }

    public void setBusinessAddressProvince(String businessAddressProvince) {
        this.businessAddressProvince = businessAddressProvince;
    }

    public String getBusinessAddressCity() {
        return this.businessAddressCity;
    }

    public void setBusinessAddressCity(String businessAddressCity) {
        this.businessAddressCity = businessAddressCity;
    }

    public String getBusinessAddressArea() {
        return this.businessAddressArea;
    }

    public void setBusinessAddressArea(String businessAddressArea) {
        this.businessAddressArea = businessAddressArea;
    }

    public String getBusinessAddress() {
        return this.businessAddress;
    }

    public void setBusinessAddress(String businessAddress) {
        this.businessAddress = businessAddress;
    }

    public String getContactName() {
        return this.contactName;
    }

    public void setContactName(String contactName) {
        this.contactName = contactName;
    }

    public String getContactEmail() {
        return this.contactEmail;
    }

    public void setContactEmail(String contactEmail) {
        this.contactEmail = contactEmail;
    }

    public String getContactPhone() {
        return this.contactPhone;
    }

    public void setContactPhone(String contactPhone) {
        this.contactPhone = contactPhone;
    }

    public String getModifyType() {
        return this.modifyType;
    }

    public void setModifyType(String modifyType) {
        this.modifyType = modifyType;
    }

    public String getBusinessLicensePath() {
        return this.businessLicensePath;
    }

    public void setBusinessLicensePath(String businessLicensePath) {
        this.businessLicensePath = businessLicensePath;
    }

    public String getOpenAccountPath() {
        return this.openAccountPath;
    }

    public void setOpenAccountPath(String openAccountPath) {
        this.openAccountPath = openAccountPath;
    }

    public String getLegalIdCardProsPath() {
        return this.legalIdCardProsPath;
    }

    public void setLegalIdCardProsPath(String legalIdCardProsPath) {
        this.legalIdCardProsPath = legalIdCardProsPath;
    }

    public String getLegalIdCardConsPath() {
        return this.legalIdCardConsPath;
    }

    public void setLegalIdCardConsPath(String legalIdCardConsPath) {
        this.legalIdCardConsPath = legalIdCardConsPath;
    }

    public String getDesireAuthPath() {
        return this.desireAuthPath;
    }

    public void setDesireAuthPath(String desireAuthPath) {
        this.desireAuthPath = desireAuthPath;
    }

    public String getDesireAuthOtherPath() {
        return this.desireAuthOtherPath;
    }

    public void setDesireAuthOtherPath(String desireAuthOtherPath) {
        this.desireAuthOtherPath = desireAuthOtherPath;
    }

    public String getHoldingIdCardPath() {
        return this.holdingIdCardPath;
    }

    public void setHoldingIdCardPath(String holdingIdCardPath) {
        this.holdingIdCardPath = holdingIdCardPath;
    }

    public String getWebSitePath() {
        return this.webSitePath;
    }

    public void setWebSitePath(String webSitePath) {
        this.webSitePath = webSitePath;
    }

    public String getWechatAppletPath() {
        return this.wechatAppletPath;
    }

    public void setWechatAppletPath(String wechatAppletPath) {
        this.wechatAppletPath = wechatAppletPath;
    }

    public String getAppPath() {
        return this.appPath;
    }

    public void setAppPath(String appPath) {
        this.appPath = appPath;
    }

    public String getLegalPersonBankCardPath() {
        return this.legalPersonBankCardPath;
    }

    public void setLegalPersonBankCardPath(String legalPersonBankCardPath) {
        this.legalPersonBankCardPath = legalPersonBankCardPath;
    }

    public String getOtherCerPath() {
        return this.otherCerPath;
    }

    public void setOtherCerPath(String otherCerPath) {
        this.otherCerPath = otherCerPath;
    }

    public String getStoreHeaderPath() {
        return this.storeHeaderPath;
    }

    public void setStoreHeaderPath(String storeHeaderPath) {
        this.storeHeaderPath = storeHeaderPath;
    }

    public String getStoreIndoorPath() {
        return this.storeIndoorPath;
    }

    public void setStoreIndoorPath(String storeIndoorPath) {
        this.storeIndoorPath = storeIndoorPath;
    }
}

