/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.serviceprovider.v3_0.declaration.builder;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.exception.UnknownException;
import com.upay.sdk.serviceprovider.v3_0.declaration.entity.InterConnectionMerchantRegistrationBankCardInfo;
import com.upay.sdk.serviceprovider.v3_0.declaration.entity.InterConnectionMerchantRegistrationBaseInfo;
import com.upay.sdk.serviceprovider.v3_0.declaration.entity.InterConnectionMerchantRegistrationCertificateInfo;

public class InterConnectionMerchantRegistrationBuilder
extends BuilderSupport {
    private String merchantId;
    private String requestId;
    private String operationType;
    private String subMerchantId;
    private String nuccMerchantId;
    private String notifyUrl;
    private InterConnectionMerchantRegistrationBaseInfo baseInfo;
    private InterConnectionMerchantRegistrationCertificateInfo certificateInfo;
    private InterConnectionMerchantRegistrationBankCardInfo bankCardInfo;

    public InterConnectionMerchantRegistrationBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    @Override
    protected String orderGenerateHmac() {
        String orderGenerateHmac = super.orderGenerateHmac();
        String hmacKey = ConfigurationUtils.getHmacKey(this.merchantId);
        return SignUtils.signMd5(orderGenerateHmac, hmacKey);
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }

    public String getMerchantId() {
        return this.merchantId;
    }

    public void setMerchantId(String merchantId) {
        this.merchantId = merchantId;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public String getOperationType() {
        return this.operationType;
    }

    public void setOperationType(String operationType) {
        this.operationType = operationType;
    }

    public String getSubMerchantId() {
        return this.subMerchantId;
    }

    public void setSubMerchantId(String subMerchantId) {
        this.subMerchantId = subMerchantId;
    }

    public String getNuccMerchantId() {
        return this.nuccMerchantId;
    }

    public void setNuccMerchantId(String nuccMerchantId) {
        this.nuccMerchantId = nuccMerchantId;
    }

    public String getNotifyUrl() {
        return this.notifyUrl;
    }

    public void setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
    }

    public InterConnectionMerchantRegistrationBaseInfo getBaseInfo() {
        return this.baseInfo;
    }

    public void setBaseInfo(InterConnectionMerchantRegistrationBaseInfo baseInfo) {
        this.baseInfo = baseInfo;
    }

    public InterConnectionMerchantRegistrationCertificateInfo getCertificateInfo() {
        return this.certificateInfo;
    }

    public void setCertificateInfo(InterConnectionMerchantRegistrationCertificateInfo certificateInfo) {
        this.certificateInfo = certificateInfo;
    }

    public InterConnectionMerchantRegistrationBankCardInfo getBankCardInfo() {
        return this.bankCardInfo;
    }

    public void setBankCardInfo(InterConnectionMerchantRegistrationBankCardInfo bankCardInfo) {
        this.bankCardInfo = bankCardInfo;
    }
}

