/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.rz.builder;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.exception.UnknownException;

public final class RzAuthTransferQueryBuilder
extends BuilderSupport {
    private String partnerId;
    private String merchantId;
    private String requestId;

    public RzAuthTransferQueryBuilder setMerchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    public RzAuthTransferQueryBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        if (this.partnerId != null) {
            return CipherWrapper.bothEncryptWrap(this.merchantId, this.partnerId, json);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }

    RzAuthTransferQueryBuilder(String partnerId, String merchantId, String requestId) {
        this.partnerId = partnerId;
        this.merchantId = merchantId;
        this.requestId = requestId;
    }

    public static RzAuthTransferQueryBuilderBuilder builder() {
        return new RzAuthTransferQueryBuilderBuilder();
    }

    public String getPartnerId() {
        return this.partnerId;
    }

    public String getMerchantId() {
        return this.merchantId;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setPartnerId(String partnerId) {
        this.partnerId = partnerId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RzAuthTransferQueryBuilder)) {
            return false;
        }
        RzAuthTransferQueryBuilder other = (RzAuthTransferQueryBuilder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$partnerId = this.getPartnerId();
        String other$partnerId = other.getPartnerId();
        if (this$partnerId == null ? other$partnerId != null : !this$partnerId.equals(other$partnerId)) {
            return false;
        }
        String this$merchantId = this.getMerchantId();
        String other$merchantId = other.getMerchantId();
        if (this$merchantId == null ? other$merchantId != null : !this$merchantId.equals(other$merchantId)) {
            return false;
        }
        String this$requestId = this.getRequestId();
        String other$requestId = other.getRequestId();
        return !(this$requestId == null ? other$requestId != null : !this$requestId.equals(other$requestId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RzAuthTransferQueryBuilder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $partnerId = this.getPartnerId();
        result = result * 59 + ($partnerId == null ? 43 : $partnerId.hashCode());
        String $merchantId = this.getMerchantId();
        result = result * 59 + ($merchantId == null ? 43 : $merchantId.hashCode());
        String $requestId = this.getRequestId();
        result = result * 59 + ($requestId == null ? 43 : $requestId.hashCode());
        return result;
    }

    public String toString() {
        return "RzAuthTransferQueryBuilder(partnerId=" + this.getPartnerId() + ", merchantId=" + this.getMerchantId() + ", requestId=" + this.getRequestId() + ")";
    }

    public static class RzAuthTransferQueryBuilderBuilder {
        private String partnerId;
        private String merchantId;
        private String requestId;

        RzAuthTransferQueryBuilderBuilder() {
        }

        public RzAuthTransferQueryBuilderBuilder partnerId(String partnerId) {
            this.partnerId = partnerId;
            return this;
        }

        public RzAuthTransferQueryBuilderBuilder merchantId(String merchantId) {
            this.merchantId = merchantId;
            return this;
        }

        public RzAuthTransferQueryBuilderBuilder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public RzAuthTransferQueryBuilder build() {
            return new RzAuthTransferQueryBuilder(this.partnerId, this.merchantId, this.requestId);
        }

        public String toString() {
            return "RzAuthTransferQueryBuilder.RzAuthTransferQueryBuilderBuilder(partnerId=" + this.partnerId + ", merchantId=" + this.merchantId + ", requestId=" + this.requestId + ")";
        }
    }
}

