/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.phoenix.v_1.executer;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.Constants;
import com.upay.sdk.HttpClientUtils;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.exception.ResponseException;
import com.upay.sdk.exception.UnknownException;
import com.upay.sdk.executer.Executer;
import com.upay.sdk.executer.ResultListener;
import com.upay.sdk.phoenix.v_1.builder.UserQueryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserQueryExecuter
extends Executer {
    static final Logger LOGGER = LoggerFactory.getLogger(UserQueryExecuter.class);

    public void userQuery(UserQueryBuilder builder, ResultListener resultListener) {
        if (resultListener == null) {
            throw new NullPointerException();
        }
        try {
            JSONObject requestData = builder.encryptBuild();
            String phoenixUserQueryUrl = ConfigurationUtils.getPhoenixUserQueryUrl();
            LOGGER.debug("UserQueryExecuter userQuery requestData:[" + requestData.toJSONString() + "],phoenixUserQueryUrl:[" + phoenixUserQueryUrl + "]");
            String responseStr = HttpClientUtils.post2(phoenixUserQueryUrl, requestData);
            LOGGER.debug("UserQueryExecuter userQuery responseStr:[" + responseStr + "]");
            JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
            String status = responseData.getString(Constants.STATUS);
            if (Constants.ERROR.equals(status)) {
                throw new ResponseException(responseData);
            }
            responseData = CipherWrapper.decryptWrap(responseData);
            LOGGER.debug("UserQueryExecuter userQuery  responseData:[" + responseData + "]");
            this.verifyHmacOrder(responseData);
            if (!Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
                throw new ResponseException(responseData);
            }
            resultListener.success(responseData);
        }
        catch (Exception e) {
            LOGGER.error("UserQueryExecuter userQuery exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }
}

