/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.phoenix.v_1.builder;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.core.CipherWrapper;

public final class UserCreateBuilder
extends BuilderSupport {
    private String merchantId;
    private String username;
    private String password;
    private String nickName;
    private String email;
    private String mobile;

    public UserCreateBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public UserCreateBuilder setUsername(String username) {
        this.username = username;
        return this;
    }

    public UserCreateBuilder setPassword(String password) {
        this.password = password;
        return this;
    }

    public UserCreateBuilder setNickName(String nickName) {
        this.nickName = nickName;
        return this;
    }

    public UserCreateBuilder setEmail(String email) {
        this.email = email;
        return this;
    }

    public UserCreateBuilder setMobile(String mobile) {
        this.mobile = mobile;
        return this;
    }

    public JSONObject encryptBuild() {
        JSONObject json = super.assembleBuild();
        json.put("hmac", (Object)this.orderGenerateHmac());
        return CipherWrapper.encryptWrap(this.merchantId, json);
    }

    @Override
    protected String orderGenerateHmac() {
        String orderGenerateHmac = super.orderGenerateHmac();
        String hmacKey = ConfigurationUtils.getHmacKey(this.merchantId);
        return SignUtils.signMd5(orderGenerateHmac, hmacKey);
    }
}

