/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.onlinepay.builder;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.exception.UnknownException;
import org.apache.commons.lang3.StringUtils;

public class OrderConfirmBuilder
extends BuilderSupport {
    private String merchantId;
    private String requestId;
    private String paymentOrderId;
    private String kaptchaCode;

    public OrderConfirmBuilder setKaptchaCode(String kaptchaCode) {
        this.kaptchaCode = kaptchaCode;
        return this;
    }

    public OrderConfirmBuilder setMerchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    public OrderConfirmBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public OrderConfirmBuilder setPaymentOrderId(String paymentOrderId) {
        this.paymentOrderId = paymentOrderId;
        return this;
    }

    public OrderConfirmBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public JSONObject build() {
        JSONObject json = super.build(this.merchantId);
        if (StringUtils.isNotBlank((CharSequence)this.requestId)) {
            json.put("requestId", (Object)this.requestId);
        }
        if (StringUtils.isNotBlank((CharSequence)this.kaptchaCode)) {
            json.put("kaptchaCode", (Object)this.kaptchaCode);
        }
        json.put("hmac", (Object)this.generateHmac());
        return json;
    }

    private String generateHmac() {
        StringBuilder hmacSource = new StringBuilder();
        hmacSource.append(StringUtils.defaultString((String)this.merchantId)).append(StringUtils.defaultString((String)this.requestId)).append(StringUtils.defaultString((String)this.kaptchaCode));
        return SignUtils.signMd5(hmacSource.toString(), ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject encryptBuild() {
        JSONObject json = super.assembleBuild();
        json.put("hmac", (Object)this.orderGenerateHmac());
        return CipherWrapper.encryptWrap(this.merchantId, json);
    }

    @Override
    protected String orderGenerateHmac() {
        String orderGenerateHmac = super.orderGenerateHmac();
        String hmacKey = ConfigurationUtils.getHmacKey(this.merchantId);
        return SignUtils.signMd5(orderGenerateHmac, hmacKey);
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }
}

