/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.onlinepay.builder;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.entity.BankCard;
import com.upay.sdk.entity.Payer;
import com.upay.sdk.entity.Pointer;
import com.upay.sdk.entity.ProductDetail;
import com.upay.sdk.entity.Receiver;
import com.upay.sdk.entity.SplitRecord;
import com.upay.sdk.entity.SubOrder;
import com.upay.sdk.entity.WeboxParams;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public final class OrderBuilder
extends BuilderSupport {
    private String merchantId;
    private String orderAmount;
    private String orderCurrency;
    private String requestId;
    private String notifyUrl;
    private String callbackUrl;
    private String remark;
    private String paymentModeCode;
    private String authCode;
    private String openId;
    private Payer payer;
    private Receiver receiver;
    private BankCard bankCard;
    private String cashierVersion;
    private String forUse;
    private String merchantUserId;
    private String bindCardId;
    private String clientIp;
    private String timeout;
    private String splitMark;
    private String splitRule;
    private String partnerId;
    private String languageType;
    private List<ProductDetail> productDetails = new LinkedList<ProductDetail>();
    private List<SubOrder> subOrders = new LinkedList<SubOrder>();
    private List<SplitRecord> splitRecords = new LinkedList<SplitRecord>();
    private String paymentToken;
    private String isBackUsersSign;
    private String appId;
    private String apCardNo;
    private String apUserData;
    private String apTransData;
    private String reportSerialNo;
    private String limitAccType;
    private String productInfo;
    private String projectId;
    private String subsidyMark;
    private String subsidyAmount;
    private String needOpenLink;
    private String reportTerminalNo;
    private String payMerchantId;
    private WeboxParams weboxParams;
    private Pointer location;

    public OrderBuilder setCashierVersion(String cashierVersion) {
        this.cashierVersion = cashierVersion;
        return this;
    }

    public OrderBuilder setForUse(String forUse) {
        this.forUse = forUse;
        return this;
    }

    public OrderBuilder setMerchantUserId(String merchantUserId) {
        this.merchantUserId = merchantUserId;
        return this;
    }

    public OrderBuilder setBindCardId(String bindCardId) {
        this.bindCardId = bindCardId;
        return this;
    }

    public OrderBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public OrderBuilder setOrderAmount(String orderAmount) {
        this.orderAmount = orderAmount;
        return this;
    }

    public OrderBuilder setOrderCurrency(String orderCurrency) {
        this.orderCurrency = orderCurrency;
        return this;
    }

    public OrderBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public OrderBuilder setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
        return this;
    }

    public OrderBuilder setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
        return this;
    }

    public OrderBuilder setRemark(String remark) {
        this.remark = remark;
        return this;
    }

    public OrderBuilder setPaymentModeCode(String paymentModeCode) {
        this.paymentModeCode = paymentModeCode;
        return this;
    }

    public OrderBuilder setAuthCode(String authCode) {
        this.authCode = authCode;
        return this;
    }

    public OrderBuilder setOpenId(String openId) {
        this.openId = openId;
        return this;
    }

    public OrderBuilder setPayer(Payer payer) {
        this.payer = payer;
        return this;
    }

    public OrderBuilder setReceiver(Receiver receiver) {
        this.receiver = receiver;
        return this;
    }

    public OrderBuilder addProductDetail(ProductDetail productDetail) {
        this.productDetails.add(productDetail);
        return this;
    }

    public OrderBuilder addSplitRecord(SplitRecord splitRecord) {
        this.splitRecords.add(splitRecord);
        return this;
    }

    public OrderBuilder addSubOrder(SubOrder subOrder) {
        this.subOrders.add(subOrder);
        return this;
    }

    public void setClientIp(String clientIp) {
        this.clientIp = clientIp;
    }

    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }

    public void setSplitMark(String splitMark) {
        this.splitMark = splitMark;
    }

    public void setSplitRule(String splitRule) {
        this.splitRule = splitRule;
    }

    public void setPaymentToken(String paymentToken) {
        this.paymentToken = paymentToken;
    }

    public void setIsBackUsersSign(String isBackUsersSign) {
        this.isBackUsersSign = isBackUsersSign;
    }

    public String getPartnerId() {
        return this.partnerId;
    }

    public void setPartnerId(String partnerId) {
        this.partnerId = partnerId;
    }

    public String getNeedOpenLink() {
        return this.needOpenLink;
    }

    public OrderBuilder setNeedOpenLink(String needOpenLink) {
        this.needOpenLink = needOpenLink;
        return this;
    }

    @Deprecated
    public JSONObject build() {
        JSONObject json = super.build(this.merchantId);
        if (StringUtils.isNotBlank((CharSequence)this.orderAmount)) {
            json.put("orderAmount", (Object)this.orderAmount);
        }
        if (StringUtils.isNotBlank((CharSequence)this.orderCurrency)) {
            json.put("orderCurrency", (Object)this.orderCurrency);
        }
        if (StringUtils.isNotBlank((CharSequence)this.requestId)) {
            json.put("requestId", (Object)this.requestId);
        }
        if (StringUtils.isNotBlank((CharSequence)this.notifyUrl)) {
            json.put("notifyUrl", (Object)this.notifyUrl);
        }
        if (StringUtils.isNotBlank((CharSequence)this.callbackUrl)) {
            json.put("callbackUrl", (Object)this.callbackUrl);
        }
        if (StringUtils.isNotBlank((CharSequence)this.remark)) {
            json.put("remark", (Object)this.remark);
        }
        if (StringUtils.isNotBlank((CharSequence)this.paymentModeCode)) {
            json.put("paymentModeCode", (Object)this.paymentModeCode);
        }
        if (StringUtils.isNotBlank((CharSequence)this.authCode)) {
            json.put("authCode", (Object)this.authCode);
        }
        if (StringUtils.isNotBlank((CharSequence)this.openId)) {
            json.put("openId", (Object)this.openId);
        }
        if (StringUtils.isNotBlank((CharSequence)this.cashierVersion)) {
            json.put("cashierVersion", (Object)this.cashierVersion);
        }
        if (StringUtils.isNotBlank((CharSequence)this.forUse)) {
            json.put("forUse", (Object)this.forUse);
        }
        if (StringUtils.isNotBlank((CharSequence)this.merchantUserId)) {
            json.put("merchantUserId", (Object)this.merchantUserId);
        }
        if (StringUtils.isNotBlank((CharSequence)this.bindCardId)) {
            json.put("bindCardId", (Object)this.bindCardId);
        }
        if (StringUtils.isNotBlank((CharSequence)this.clientIp)) {
            json.put("clientIp", (Object)this.clientIp);
        }
        if (StringUtils.isNotBlank((CharSequence)this.timeout)) {
            json.put("timeout", (Object)this.timeout);
        }
        if (StringUtils.isNotBlank((CharSequence)this.splitMark)) {
            json.put("splitMark", (Object)this.splitMark);
        }
        if (StringUtils.isNotBlank((CharSequence)this.splitRule)) {
            json.put("splitRule", (Object)this.splitRule);
        }
        if (StringUtils.isNotBlank((CharSequence)this.paymentToken)) {
            json.put("paymentToken", (Object)this.paymentToken);
        }
        if (StringUtils.isNotBlank((CharSequence)this.isBackUsersSign)) {
            json.put("isBackUsersSign", (Object)this.isBackUsersSign);
        }
        if (StringUtils.isNotBlank((CharSequence)this.appId)) {
            json.put("appId", (Object)this.appId);
        }
        json.put("productDetails", this.productDetails);
        json.put("payer", (Object)this.payer);
        json.put("receiver", (Object)this.receiver);
        json.put("bankCard", (Object)this.bankCard);
        json.put("subOrders", this.subOrders);
        json.put("splitRecords", this.splitRecords);
        if (StringUtils.isNotBlank((CharSequence)this.authCode)) {
            json.put("authCode", (Object)this.authCode);
        }
        if (StringUtils.isNotBlank((CharSequence)this.partnerId)) {
            json.put("partnerId", (Object)this.partnerId);
        }
        json.put("hmac", (Object)this.generateHmac());
        return json;
    }

    public BankCard getBankCard() {
        return this.bankCard;
    }

    public void setBankCard(BankCard bankCard) {
        this.bankCard = bankCard;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    @Deprecated
    private String generateHmac() {
        StringBuilder hmacSource = new StringBuilder();
        hmacSource.append(StringUtils.defaultString((String)this.merchantId)).append((String)ObjectUtils.defaultIfNull((Object)this.orderAmount, (Object)"")).append(StringUtils.defaultString((String)this.orderCurrency, (String)"")).append(StringUtils.defaultString((String)this.requestId, (String)"")).append(StringUtils.defaultString((String)this.notifyUrl, (String)"")).append(StringUtils.defaultString((String)this.callbackUrl, (String)"")).append(StringUtils.defaultString((String)this.remark, (String)"")).append(StringUtils.defaultString((String)this.paymentModeCode, (String)""));
        if (this.productDetails != null) {
            for (ProductDetail productDetail : this.productDetails) {
                hmacSource.append(StringUtils.defaultString((String)productDetail.getName())).append(ObjectUtils.defaultIfNull((Object)productDetail.getQuantity(), (Object)"")).append(ObjectUtils.defaultIfNull((Object)productDetail.getAmount(), (Object)"")).append(StringUtils.defaultString((String)productDetail.getReceiver())).append(StringUtils.defaultString((String)productDetail.getDescription()));
            }
        }
        if (this.splitRecords != null) {
            for (SplitRecord splitRecord : this.splitRecords) {
                hmacSource.append(StringUtils.defaultString((String)splitRecord.getMerchantInfo(), (String)"")).append(StringUtils.defaultString((String)splitRecord.getMerchantMark(), (String)"")).append(StringUtils.defaultString((String)splitRecord.getSplitRemark(), (String)"")).append(ObjectUtils.defaultIfNull((Object)splitRecord.getSplitAmount(), (Object)""));
            }
        }
        if (this.payer != null) {
            hmacSource.append(StringUtils.defaultString((String)this.payer.getName())).append(StringUtils.defaultString((String)this.payer.getPhoneNum())).append(StringUtils.defaultString((String)this.payer.getIdNum())).append(StringUtils.defaultString((String)this.payer.getBankCardNum())).append(StringUtils.defaultString((String)this.payer.getEmail()));
        }
        if (this.bankCard != null) {
            hmacSource.append(StringUtils.defaultString((String)this.bankCard.getName())).append(StringUtils.defaultString((String)this.bankCard.getCardNo())).append(StringUtils.defaultString((String)this.bankCard.getCvv2())).append(StringUtils.defaultString((String)this.bankCard.getIdNo())).append(StringUtils.defaultString((String)this.bankCard.getExpiryDate())).append(StringUtils.defaultString((String)this.bankCard.getMobileNo()));
        }
        hmacSource.append(StringUtils.defaultString((String)this.cashierVersion, (String)""));
        hmacSource.append(StringUtils.defaultString((String)this.forUse, (String)""));
        hmacSource.append(StringUtils.defaultString((String)this.merchantUserId, (String)""));
        hmacSource.append(StringUtils.defaultString((String)this.bindCardId, (String)""));
        hmacSource.append(StringUtils.defaultString((String)this.clientIp, (String)""));
        hmacSource.append(StringUtils.defaultString((String)this.timeout, (String)""));
        hmacSource.append(StringUtils.defaultString((String)this.splitMark, (String)""));
        hmacSource.append(StringUtils.defaultString((String)this.splitRule, (String)""));
        if (this.subOrders != null) {
            for (SubOrder order : this.subOrders) {
                hmacSource.append(StringUtils.defaultString((String)order.getRequestId())).append(ObjectUtils.defaultIfNull((Object)order.getOrderAmount(), (Object)""));
            }
        }
        hmacSource.append(StringUtils.defaultString((String)this.authCode, (String)""));
        hmacSource.append(StringUtils.defaultString((String)this.openId, (String)""));
        if (this.receiver != null) {
            hmacSource.append(StringUtils.defaultString((String)this.receiver.getReceiver())).append(StringUtils.defaultString((String)this.receiver.getPhoneNum())).append(StringUtils.defaultString((String)this.receiver.getAddress()));
        }
        hmacSource.append(StringUtils.defaultString((String)this.isBackUsersSign, (String)""));
        hmacSource.append(StringUtils.defaultString((String)this.appId, (String)""));
        hmacSource.append(StringUtils.defaultString((String)this.partnerId, (String)""));
        return SignUtils.signMd5(hmacSource.toString(), ConfigurationUtils.getHmacKey(StringUtils.isBlank((CharSequence)this.partnerId) ? this.merchantId : this.partnerId));
    }

    public JSONObject encryptBuild() {
        JSONObject json = super.assembleBuild();
        json.put("hmac", (Object)this.orderGenerateHmac());
        if (StringUtils.isNotBlank((CharSequence)this.partnerId)) {
            return CipherWrapper.bothEncryptWrap(this.merchantId, this.partnerId, json);
        }
        return CipherWrapper.encryptWrap(this.merchantId, json);
    }

    @Override
    protected String orderGenerateHmac() {
        return SignUtils.signMd5(super.orderGenerateHmac(), ConfigurationUtils.getHmacKey(StringUtils.isBlank((CharSequence)this.partnerId) ? this.merchantId : this.partnerId));
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (StringUtils.isNotBlank((CharSequence)this.partnerId)) {
            return CipherWrapper.bothEncryptWrap(this.merchantId, this.partnerId, json);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }

    public void setApCardNo(String apCardNo) {
        this.apCardNo = apCardNo;
    }

    public void setApUserData(String apUserData) {
        this.apUserData = apUserData;
    }

    public void setApTransData(String apTransData) {
        this.apTransData = apTransData;
    }

    public void setReportSerialNo(String reportSerialNo) {
        this.reportSerialNo = reportSerialNo;
    }

    public String getProductInfo() {
        return this.productInfo;
    }

    public void setProductInfo(String productInfo) {
        this.productInfo = productInfo;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public String getLimitAccType() {
        return this.limitAccType;
    }

    public void setLimitAccType(String limitAccType) {
        this.limitAccType = limitAccType;
    }

    public String getSubsidyMark() {
        return this.subsidyMark;
    }

    public void setSubsidyMark(String subsidyMark) {
        this.subsidyMark = subsidyMark;
    }

    public String getSubsidyAmount() {
        return this.subsidyAmount;
    }

    public void setSubsidyAmount(String subsidyAmount) {
        this.subsidyAmount = subsidyAmount;
    }

    public OrderBuilder setReportTerminalNo(String reportTerminalNo) {
        this.reportTerminalNo = reportTerminalNo;
        return this;
    }

    public String getPayMerchantId() {
        return this.payMerchantId;
    }

    public void setPayMerchantId(String payMerchantId) {
        this.payMerchantId = payMerchantId;
    }

    public WeboxParams getWeboxParams() {
        return this.weboxParams;
    }

    public void setWeboxParams(WeboxParams weboxParams) {
        this.weboxParams = weboxParams;
    }

    public Pointer getLocation() {
        return this.location;
    }

    public void setLocation(Pointer location) {
        this.location = location;
    }

    public String getLanguageType() {
        return this.languageType;
    }

    public OrderBuilder setLanguageType(String languageType) {
        this.languageType = languageType;
        return this;
    }
}

