/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.jointaccount.v_3.executer;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.Constants;
import com.upay.sdk.HttpClientUtils;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.exception.ResponseException;
import com.upay.sdk.exception.UnknownException;
import com.upay.sdk.executer.Executer;
import com.upay.sdk.executer.ResultListener;
import com.upay.sdk.jointaccount.v_3.builder.NewRetailSubsidyBuilder;
import com.upay.sdk.jointaccount.v_3.builder.NewRetailSubsidyQueryBuilder;
import com.upay.sdk.jointaccount.v_3.builder.NewRetailSubsidyRefundBuilder;
import com.upay.sdk.jointaccount.v_3.builder.NewRetailSubsidyRefundQueryBuilder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewRetailSubsidyExecutor
extends Executer {
    static final Logger LOGGER = LoggerFactory.getLogger(NewRetailSubsidyExecutor.class);

    public void splitOrder(NewRetailSubsidyBuilder builder, ResultListener listener) {
        try {
            JSONObject requestData = builder.bothEncryptBuild();
            LOGGER.info("requestData:[" + requestData.toJSONString() + "]");
            String url = ConfigurationUtils.getNewRetailSubsidyOrderUrl();
            String responseStr = HttpClientUtils.post3(url, requestData);
            LOGGER.info("responseStr:[{}]", (Object)responseStr);
            JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
            responseData = CipherWrapper.bothDecryptWrap(responseData);
            LOGGER.info("responseStr:[" + responseData + "]");
            this.bothVerifyHmacOrder(responseData);
            String status = responseData.getString(Constants.STATUS);
            if (!Constants.SUCCESS.equals(status)) {
                throw new ResponseException(responseData);
            }
            listener.success(responseData);
        }
        catch (Exception e) {
            LOGGER.error("request subsidy split order exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }

    public void splitOrderQuery(NewRetailSubsidyQueryBuilder builder, ResultListener listener) {
        try {
            JSONObject requestData = builder.bothEncryptBuild();
            LOGGER.info("requestData:[" + requestData.toJSONString() + "]");
            String url = ConfigurationUtils.getNewRetailSubsidyOrderQueryUrl();
            String responseStr = HttpClientUtils.post3(url, requestData);
            LOGGER.info("responseStr:[{}]", (Object)responseStr);
            JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
            responseData = CipherWrapper.bothDecryptWrap(responseData);
            LOGGER.info("responseStr:[" + responseData + "]");
            this.bothVerifyHmacOrder(responseData);
            String status = responseData.getString(Constants.STATUS);
            if (!Constants.SUCCESS.equals(status)) {
                throw new ResponseException(responseData);
            }
            listener.success(responseData);
        }
        catch (Exception e) {
            LOGGER.error("request subsidy splitOrderQuery exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }

    public void refund(NewRetailSubsidyRefundBuilder builder, ResultListener listener) {
        try {
            JSONObject requestData = builder.bothEncryptBuild();
            LOGGER.info("requestData:[" + requestData.toJSONString() + "]");
            String url = ConfigurationUtils.getNewRetailSubsidyRefundUrl();
            String responseStr = HttpClientUtils.post3(url, requestData);
            LOGGER.info("responseStr:[{}]", (Object)responseStr);
            JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
            responseData = CipherWrapper.bothDecryptWrap(responseData);
            LOGGER.info("responseStr:[" + responseData + "]");
            this.bothVerifyHmacOrder(responseData);
            String status = responseData.getString(Constants.STATUS);
            if (!Constants.SUCCESS.equals(status)) {
                throw new ResponseException(responseData);
            }
            listener.success(responseData);
        }
        catch (Exception e) {
            LOGGER.error("request subsidy refund exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }

    public void refundQuery(NewRetailSubsidyRefundQueryBuilder builder, ResultListener listener) {
        try {
            JSONObject requestData = builder.bothEncryptBuild();
            LOGGER.info("requestData:[" + requestData.toJSONString() + "]");
            String url = ConfigurationUtils.getNewRetailSubsidyRefundQueryUrl();
            String responseStr = HttpClientUtils.post3(url, requestData);
            LOGGER.info("responseStr:[{}]", (Object)responseStr);
            JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
            responseData = CipherWrapper.bothDecryptWrap(responseData);
            LOGGER.info("responseStr:[" + responseData + "]");
            this.bothVerifyHmacOrder(responseData);
            String status = responseData.getString(Constants.STATUS);
            if (!Constants.SUCCESS.equals(status)) {
                throw new ResponseException(responseData);
            }
            listener.success(responseData);
        }
        catch (Exception e) {
            LOGGER.error("request subsidy refundQuery exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }

    public void bothCipherCallback(JSONObject responseData, ResultListener listener) {
        block5: {
            try {
                JSONObject data = CipherWrapper.bothDecryptWrap(responseData);
                this.bothVerifyHmacOrder(data);
                String status = data.getString(Constants.STATUS);
                if (!StringUtils.isNotBlank((CharSequence)status)) break block5;
                if (Constants.SUCCESS.equals(status)) {
                    listener.success(data);
                    break block5;
                }
                if (Constants.FAILED.equals(status) || Constants.CANCEL.equals(status)) {
                    listener.failure(data);
                    break block5;
                }
                if (Constants.INIT.equals(status)) {
                    listener.pending(data);
                    break block5;
                }
                throw new ResponseException(data);
            }
            catch (Exception e) {
                LOGGER.error("subsidy split order callback exception", (Throwable)e);
                throw new UnknownException(e);
            }
        }
    }
}

