/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.eshopping.vcc.builder;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.exception.UnknownException;

public class GetMerchantListPriceBuilder
extends BuilderSupport {
    private String merchantId;
    private String startListPriceDate;
    private String endListPriceDate;

    public GetMerchantListPriceBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public JSONObject encryptBuild() {
        JSONObject json = super.assembleBuild();
        json.put("hmac", (Object)this.orderGenerateHmac());
        return CipherWrapper.encryptWrap(this.merchantId, json);
    }

    @Override
    protected String orderGenerateHmac() {
        return SignUtils.signMd5(super.orderGenerateHmac(), ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }

    public String getMerchantId() {
        return this.merchantId;
    }

    public GetMerchantListPriceBuilder setMerchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    public String getStartListPriceDate() {
        return this.startListPriceDate;
    }

    public void setStartListPriceDate(String startListPriceDate) {
        this.startListPriceDate = startListPriceDate;
    }

    public String getEndListPriceDate() {
        return this.endListPriceDate;
    }

    public void setEndListPriceDate(String endListPriceDate) {
        this.endListPriceDate = endListPriceDate;
    }
}

