/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.ert.v_3.v2.builder;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.exception.UnknownException;
import org.apache.commons.lang3.StringUtils;

public final class ReceiptPaymentBuilder
extends BuilderSupport {
    private String merchantId;
    private String requestId;
    private String sms;
    private String cvv;
    private String expiredYear;
    private String expiredMonth;
    private String clientIp;
    private String partnerId;

    public ReceiptPaymentBuilder setMerchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    public ReceiptPaymentBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public ReceiptPaymentBuilder setSms(String sms) {
        this.sms = sms;
        return this;
    }

    public ReceiptPaymentBuilder setCvv(String cvv) {
        this.cvv = cvv;
        return this;
    }

    public ReceiptPaymentBuilder setExpiredYear(String expiredYear) {
        this.expiredYear = expiredYear;
        return this;
    }

    public ReceiptPaymentBuilder setExpiredMonth(String expiredMonth) {
        this.expiredMonth = expiredMonth;
        return this;
    }

    public ReceiptPaymentBuilder setClientIp(String clientIp) {
        this.clientIp = clientIp;
        return this;
    }

    public String getPartnerId() {
        return this.partnerId;
    }

    public ReceiptPaymentBuilder setPartnerId(String partnerId) {
        this.partnerId = partnerId;
        return this;
    }

    @Override
    protected String orderGenerateHmac() {
        return SignUtils.signMd5(super.orderGenerateHmac(), ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        if (StringUtils.isNotBlank((CharSequence)this.partnerId)) {
            return CipherWrapper.bothEncryptWrap(this.merchantId, this.partnerId, json);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }
}

