/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.declaration.v_3.subMerchant.executer;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.Constants;
import com.upay.sdk.HttpClientUtils;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.declaration.v_3.subMerchant.builder.SubMerchantDeclareBuilder;
import com.upay.sdk.declaration.v_3.subMerchant.builder.SubMerchantQueryBuilder;
import com.upay.sdk.exception.ResponseException;
import com.upay.sdk.exception.UnknownException;
import com.upay.sdk.executer.Executer;
import com.upay.sdk.executer.ResultListener;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubMerchantDeclareExecuter
extends Executer {
    static final Logger LOGGER = LoggerFactory.getLogger(SubMerchantDeclareExecuter.class);

    public void bothSubMerchantDeclare(SubMerchantDeclareBuilder builder, ResultListener resultListener) {
        block5: {
            try {
                JSONObject requestData = builder.bothEncryptBuild();
                LOGGER.debug("subMerchantDeclare requestData:[" + requestData.toJSONString() + "]");
                String responseStr = HttpClientUtils.post3(ConfigurationUtils.getDeclarationSubMerchantDeclareUrl(), requestData);
                LOGGER.info("subMerchantDeclare responseStr:[" + responseStr + "]");
                JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
                responseData = CipherWrapper.bothDecryptWrap(responseData);
                LOGGER.info("responseStr:[" + responseData + "]");
                String status = responseData.getString(Constants.STATUS);
                if (Constants.ERROR.equals(status)) {
                    throw new ResponseException(responseData);
                }
                this.bothVerifyHmacOrder(responseData);
                if (Constants.SUCCESS.equals(status)) {
                    resultListener.success(responseData);
                    break block5;
                }
                if (Constants.FAILED.equals(status)) {
                    resultListener.failure(responseData);
                    break block5;
                }
                throw new ResponseException(responseData);
            }
            catch (Exception e) {
                LOGGER.error("bothSubMerchantDeclare error", (Throwable)e);
                throw new UnknownException(e);
            }
        }
    }

    public void bothSubMerchantQuery(SubMerchantQueryBuilder builder, ResultListener resultListener) {
        block5: {
            try {
                JSONObject requestData = builder.bothEncryptBuild();
                LOGGER.info("bothSubMerchantQuery requestData:[" + requestData.toJSONString() + "]");
                String responseStr = HttpClientUtils.post3(ConfigurationUtils.getDeclarationSubMerchantQueryUrl(), requestData);
                LOGGER.info("bothSubMerchantQuery responseStr:[" + responseStr + "]");
                JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
                responseData = CipherWrapper.bothDecryptWrap(responseData);
                LOGGER.info("responseStr:[" + responseData + "]");
                String status = responseData.getString(Constants.STATUS);
                if (Constants.ERROR.equals(status)) {
                    throw new ResponseException(responseData);
                }
                this.bothVerifyHmacOrder(responseData);
                if (Constants.SUCCESS.equals(status)) {
                    resultListener.success(responseData);
                    break block5;
                }
                if (Constants.FAILED.equals(status)) {
                    resultListener.failure(responseData);
                    break block5;
                }
                throw new ResponseException(responseData);
            }
            catch (Exception e) {
                LOGGER.error("bothSubMerchantQuery error", (Throwable)e);
                throw new UnknownException(e);
            }
        }
    }

    public void bothCipherCallback(JSONObject responseData, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        JSONObject data = CipherWrapper.bothDecryptWrap(responseData);
        this.bothVerifyHmacOrder(data);
        String status = data.getString(Constants.STATUS);
        if (StringUtils.isNotBlank((CharSequence)status)) {
            if (Constants.SUCCESS.equals(status)) {
                listener.success(data);
            } else if (Constants.FAILED.equals(status) || Constants.CANCEL.equals(status)) {
                listener.failure(data);
            } else if (Constants.INIT.equals(status)) {
                listener.pending(data);
            } else {
                throw new ResponseException(data);
            }
        }
    }
}

