/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.customerinforeport.executer;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.Constants;
import com.upay.sdk.HttpClientUtils;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.customerinforeport.builder.ForeignCustomerInfoReportBuilder;
import com.upay.sdk.customerinforeport.builder.ForeignCustomerReportQueryBuilder;
import com.upay.sdk.exception.ResponseException;
import com.upay.sdk.exception.UnknownException;
import com.upay.sdk.executer.Executer;
import com.upay.sdk.executer.ResultListener;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForeignCustomerReportExecuter
extends Executer {
    static final Logger LOGGER = LoggerFactory.getLogger(ForeignCustomerReportExecuter.class);

    public void orderV_3(ForeignCustomerInfoReportBuilder builder, ResultListener resultListener) {
        try {
            JSONObject requestData = builder.bothEncryptBuild();
            LOGGER.debug("ForeignCustomerReportExecuter requestData:[" + requestData.toJSONString() + "],customsReportOrderUrl:[" + ConfigurationUtils.getForeignCustomsReportUrl() + "]");
            String responseStr = HttpClientUtils.post3(ConfigurationUtils.getForeignCustomsReportUrl(), requestData);
            LOGGER.debug("responseStr:[" + responseStr + "]");
            JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
            responseData = CipherWrapper.bothDecryptWrap(responseData);
            LOGGER.debug("responseStr:[" + responseData + "]");
            this.bothVerifyHmacOrder(responseData);
            if (!Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
                throw new ResponseException(responseData);
            }
            resultListener.success(responseData);
        }
        catch (Exception e) {
            LOGGER.error("request order exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }

    public void callbackV_3(JSONObject responseData, ResultListener customsListener) {
        LOGGER.info("ForeignCustomerReportExecuter callbackV_3 responseData:[" + responseData + "]");
        if (customsListener == null) {
            throw new NullPointerException();
        }
        JSONObject data = CipherWrapper.bothDecryptWrap(responseData);
        LOGGER.info("ForeignCustomerReportExecuter callbackV_3 data:[" + data + "]");
        this.bothVerifyHmacOrder(data);
        String status = data.getString(Constants.STATUS);
        if (StringUtils.isNotBlank((CharSequence)status)) {
            if (Constants.SUCCESS.equals(status)) {
                customsListener.success(data);
            } else if (Constants.FAILED.equals(status) || Constants.CANCEL.equals(status)) {
                customsListener.failure(data);
            } else if (Constants.INIT.equals(status)) {
                customsListener.pending(data);
            } else {
                throw new ResponseException(data);
            }
        }
    }

    public void queryV_3(ForeignCustomerReportQueryBuilder builder, ResultListener customsListener) {
        if (customsListener == null) {
            throw new NullPointerException();
        }
        try {
            JSONObject requestData = builder.bothEncryptBuild();
            LOGGER.debug("ForeignCustomerReportExecuter queryV_3 requestData:[" + requestData.toJSONString() + "]");
            String responseStr = HttpClientUtils.post3(ConfigurationUtils.getForeignCustomsReportQueryUrl(), requestData);
            LOGGER.debug("ForeignCustomerReportExecuter queryV_3 responseStr:[" + responseStr + "]");
            JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
            this.callbackV_3(responseData, customsListener);
        }
        catch (Exception e) {
            LOGGER.error("ForeignCustomerReportExecuter queryv_3 exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }
}

