/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.customerinforeport.builder;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.exception.UnknownException;
import org.apache.commons.lang3.StringUtils;

public class ForeignCustomerReportQueryBuilder
extends BuilderSupport {
    private String merchantId;
    private String channelType;
    private String custCode;

    public ForeignCustomerReportQueryBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public ForeignCustomerReportQueryBuilder setChannelType(String channelType) {
        this.channelType = channelType;
        return this;
    }

    public ForeignCustomerReportQueryBuilder setCustCode(String custCode) {
        this.custCode = custCode;
        return this;
    }

    public JSONObject build() {
        JSONObject json = super.build(this.merchantId);
        if (StringUtils.isNotBlank((CharSequence)this.channelType)) {
            json.put("channelType", (Object)this.channelType);
        }
        if (StringUtils.isNotBlank((CharSequence)this.custCode)) {
            json.put("custCode", (Object)this.custCode);
        }
        json.put("hmac", (Object)this.generateHmac());
        return json;
    }

    private String generateHmac() {
        StringBuilder hmacSource = new StringBuilder();
        hmacSource.append(StringUtils.defaultString((String)this.merchantId)).append(StringUtils.defaultString((String)this.channelType)).append(StringUtils.defaultString((String)this.custCode));
        return SignUtils.signMd5(hmacSource.toString(), ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }
}

