/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.consumerFinance.v_2.executer;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.Constants;
import com.upay.sdk.HttpClientUtils;
import com.upay.sdk.consumerFinance.v_2.builder.OrderBuilder;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.exception.ResponseException;
import com.upay.sdk.exception.UnknownException;
import com.upay.sdk.executer.Executer;
import com.upay.sdk.executer.ResultListener;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrderExecuter
extends Executer {
    static final Logger LOGGER = LoggerFactory.getLogger(OrderExecuter.class);

    public void order(OrderBuilder builder, ResultListener resultListener) {
        try {
            JSONObject requestData = builder.encryptBuild();
            LOGGER.info("consumerFinance order requestData:[" + requestData.toJSONString() + "]");
            String responseStr = HttpClientUtils.post2(ConfigurationUtils.getConsumerFinanceOrderUrl(), requestData);
            JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
            String status = responseData.getString(Constants.STATUS);
            if (Constants.ERROR.equals(status)) {
                throw new ResponseException(responseData);
            }
            responseData = CipherWrapper.decryptWrap(responseData);
            LOGGER.info("consumerFinance order responseStr:[" + responseData + "]");
            this.verifyHmacOrder(responseData);
            if (!Constants.REDIRECT.equals(responseData.getString(Constants.STATUS))) {
                throw new ResponseException(responseData);
            }
            resultListener.redirect(responseData, responseData.getString("redirectUrl"));
        }
        catch (Exception e) {
            LOGGER.error("consumerFinance order request order exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }

    public void cipherCallback(JSONObject responseData, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        JSONObject data = CipherWrapper.decryptWrap(responseData);
        this.verifyHmacOrder(data);
        String status = data.getString(Constants.STATUS);
        if (StringUtils.isNotBlank((CharSequence)status)) {
            if ("LOANED".equals(status)) {
                listener.success(data);
            } else if (Constants.FAILED.equals(status) || "CANCLE".equals(status)) {
                listener.failure(data);
            } else {
                throw new ResponseException(data);
            }
        }
    }
}

