/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.crypto.sm.crypto.symmetric;

import com.upay.sdk.crypto.codec.Base64;
import com.upay.sdk.crypto.exception.CryptoException;
import com.upay.sdk.crypto.sm.crypto.KeyUtil;
import com.upay.sdk.crypto.sm.crypto.Padding;
import com.upay.sdk.crypto.sm.crypto.RandomUtil;
import com.upay.sdk.crypto.sm.crypto.SecureUtil;
import com.upay.sdk.crypto.sm.crypto.symmetric.SymmetricDecryptor;
import com.upay.sdk.crypto.sm.crypto.symmetric.SymmetricEncryptor;
import com.upay.sdk.crypto.utils.CryptoUtils;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEParameterSpec;

public class SymmetricCrypto
implements SymmetricEncryptor,
SymmetricDecryptor,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final int EOF = -1;
    private SecretKey secretKey;
    private Cipher cipher;
    private AlgorithmParameterSpec params;
    private boolean isZeroPadding;
    private final Lock lock = new ReentrantLock();

    public SymmetricCrypto(String algorithm) {
        this(algorithm, (byte[])null);
    }

    public SymmetricCrypto(String algorithm, byte[] key) {
        this(algorithm, KeyUtil.generateKey(algorithm, key));
    }

    public SymmetricCrypto(String algorithm, SecretKey key) {
        this(algorithm, key, null);
    }

    public SymmetricCrypto(String algorithm, SecretKey key, AlgorithmParameterSpec paramsSpec) {
        this.init(algorithm, key);
        this.initParams(algorithm, paramsSpec);
    }

    public SymmetricCrypto init(String algorithm, SecretKey key) {
        this.secretKey = key;
        if (algorithm.contains(Padding.ZeroPadding.name())) {
            algorithm = CryptoUtils.replace((CharSequence)algorithm, (CharSequence)Padding.ZeroPadding.name(), (CharSequence)Padding.NoPadding.name());
            this.isZeroPadding = true;
        }
        this.cipher = SecureUtil.createCipher(algorithm);
        return this;
    }

    public SecretKey getSecretKey() {
        return this.secretKey;
    }

    public Cipher getCipher() {
        return this.cipher;
    }

    public SymmetricCrypto setParams(AlgorithmParameterSpec params) {
        this.params = params;
        return this;
    }

    public SymmetricCrypto setIv(IvParameterSpec iv) {
        this.setParams(iv);
        return this;
    }

    public SymmetricCrypto setIv(byte[] iv) {
        this.setIv(new IvParameterSpec(iv));
        return this;
    }

    @Override
    public byte[] encrypt(byte[] data) {
        this.lock.lock();
        try {
            Cipher cipher = this.initMode(1);
            byte[] byArray = cipher.doFinal(this.paddingDataWithZero(data, cipher.getBlockSize()));
            return byArray;
        }
        catch (Exception e) {
            throw new CryptoException((Throwable)e);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public byte[] decrypt(byte[] bytes) {
        byte[] decryptData;
        int blockSize;
        this.lock.lock();
        try {
            Cipher cipher = this.initMode(2);
            blockSize = cipher.getBlockSize();
            decryptData = cipher.doFinal(bytes);
        }
        catch (Exception e) {
            throw new CryptoException((Throwable)e);
        }
        finally {
            this.lock.unlock();
        }
        return this.removePadding(decryptData, blockSize);
    }

    private void initParams(String algorithm, AlgorithmParameterSpec paramsSpec) {
        if (null == paramsSpec) {
            byte[] iv = null;
            Cipher cipher = this.cipher;
            if (null != cipher) {
                iv = cipher.getIV();
            }
            if (CryptoUtils.startWithIgnoreCase((CharSequence)algorithm, (CharSequence)"PBE")) {
                if (null == iv) {
                    iv = RandomUtil.randomBytes(8);
                }
                paramsSpec = new PBEParameterSpec(iv, 100);
            } else if (CryptoUtils.startWithIgnoreCase((CharSequence)algorithm, (CharSequence)"AES") && null != iv) {
                paramsSpec = new IvParameterSpec(iv);
            }
        }
        this.setParams(paramsSpec);
    }

    private Cipher initMode(int mode) throws InvalidKeyException, InvalidAlgorithmParameterException {
        Cipher cipher = this.cipher;
        if (null == this.params) {
            cipher.init(mode, this.secretKey);
        } else {
            cipher.init(mode, (Key)this.secretKey, this.params);
        }
        return cipher;
    }

    private byte[] paddingDataWithZero(byte[] data, int blockSize) {
        int length;
        int remainLength;
        if (this.isZeroPadding && (remainLength = (length = data.length) % blockSize) > 0) {
            return CryptoUtils.resize((byte[])data, (int)(length + blockSize - remainLength));
        }
        return data;
    }

    private byte[] removePadding(byte[] data, int blockSize) {
        int length;
        int remainLength;
        if (this.isZeroPadding && blockSize > 0 && (remainLength = (length = data.length) % blockSize) == 0) {
            int i;
            for (i = length - 1; i >= 0 && 0 == data[i]; --i) {
            }
            return CryptoUtils.resize((byte[])data, (int)(i + 1));
        }
        return data;
    }

    @Override
    public String decryptStr(byte[] bytes, Charset charset) {
        return CryptoUtils.str((byte[])this.decrypt(bytes), (Charset)charset);
    }

    @Override
    public String decryptStr(byte[] bytes) {
        return this.decryptStr(bytes, CryptoUtils.CHARSET_UTF_8);
    }

    @Override
    public byte[] decrypt(String data) {
        return this.decrypt(SecureUtil.decode(data));
    }

    @Override
    public String decryptStr(String data, Charset charset) {
        return CryptoUtils.str((byte[])this.decrypt(data), (Charset)charset);
    }

    @Override
    public String decryptStr(String data) {
        return this.decryptStr(data, CryptoUtils.CHARSET_UTF_8);
    }

    @Override
    public String encryptHex(byte[] data) {
        return CryptoUtils.encodeHexStr((byte[])this.encrypt(data));
    }

    @Override
    public String encryptBase64(byte[] data) {
        return Base64.encode((byte[])this.encrypt(data));
    }

    @Override
    public byte[] encrypt(String data, String charset) {
        return this.encrypt(CryptoUtils.bytes((CharSequence)data, (Charset)CryptoUtils.charset((String)charset)));
    }

    @Override
    public byte[] encrypt(String data, Charset charset) {
        return this.encrypt(CryptoUtils.bytes((CharSequence)data, (Charset)charset));
    }

    @Override
    public String encryptHex(String data, String charset) {
        return CryptoUtils.encodeHexStr((byte[])this.encrypt(data, charset));
    }

    @Override
    public String encryptHex(String data, Charset charset) {
        return CryptoUtils.encodeHexStr((byte[])this.encrypt(data, charset));
    }

    @Override
    public String encryptBase64(String data, String charset) {
        return Base64.encode((byte[])this.encrypt(data, charset));
    }

    @Override
    public String encryptBase64(String data, Charset charset) {
        return Base64.encode((byte[])this.encrypt(data, charset));
    }

    @Override
    public byte[] encrypt(String data) {
        return this.encrypt(CryptoUtils.bytes((CharSequence)data, (Charset)CryptoUtils.CHARSET_UTF_8));
    }

    @Override
    public String encryptHex(String data) {
        return CryptoUtils.encodeHexStr((byte[])this.encrypt(data));
    }

    @Override
    public String encryptBase64(String data) {
        return Base64.encode((byte[])this.encrypt(data));
    }
}

