/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.crypto.sm.crypto.symmetric;

import com.upay.sdk.crypto.sm.crypto.Mode;
import com.upay.sdk.crypto.sm.crypto.Padding;
import com.upay.sdk.crypto.sm.crypto.SecureUtil;
import com.upay.sdk.crypto.sm.crypto.symmetric.SymmetricCrypto;
import com.upay.sdk.crypto.utils.CryptoUtils;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import org.apache.commons.lang3.ArrayUtils;

public class SM4
extends SymmetricCrypto {
    private static final long serialVersionUID = 1L;
    public static final String ALGORITHM_NAME = "SM4";

    public SM4() {
        super(ALGORITHM_NAME);
    }

    public SM4(byte[] key) {
        super(ALGORITHM_NAME, key);
    }

    public SM4(Mode mode, Padding padding) {
        this(mode.name(), padding.name());
    }

    public SM4(Mode mode, Padding padding, byte[] key) {
        this(mode, padding, key, null);
    }

    public SM4(Mode mode, Padding padding, byte[] key, byte[] iv) {
        this(mode.name(), padding.name(), key, iv);
    }

    public SM4(Mode mode, Padding padding, SecretKey key) {
        this(mode, padding, key, (IvParameterSpec)null);
    }

    public SM4(Mode mode, Padding padding, SecretKey key, byte[] iv) {
        this(mode, padding, key, ArrayUtils.isEmpty((byte[])iv) ? null : new IvParameterSpec(iv));
    }

    public SM4(Mode mode, Padding padding, SecretKey key, IvParameterSpec iv) {
        this(mode.name(), padding.name(), key, iv);
    }

    public SM4(String mode, String padding) {
        this(mode, padding, (byte[])null);
    }

    public SM4(String mode, String padding, byte[] key) {
        this(mode, padding, key, null);
    }

    public SM4(String mode, String padding, byte[] key, byte[] iv) {
        this(mode, padding, SecureUtil.generateKey(ALGORITHM_NAME, key), ArrayUtils.isEmpty((byte[])iv) ? null : new IvParameterSpec(iv));
    }

    public SM4(String mode, String padding, SecretKey key) {
        this(mode, padding, key, null);
    }

    public SM4(String mode, String padding, SecretKey key, IvParameterSpec iv) {
        super(CryptoUtils.format((String)"SM4/{}/{}", (Object[])new Object[]{mode, padding}), key, iv);
    }
}

