/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.crypto.sm.crypto.digest;

import com.upay.sdk.crypto.exception.CryptoException;
import com.upay.sdk.crypto.sm.crypto.SecureUtil;
import com.upay.sdk.crypto.utils.CryptoUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;

public class Digester
implements Serializable {
    private static final long serialVersionUID = 1L;
    int DEFAULT_BUFFER_SIZE = 8192;
    private MessageDigest digest;
    protected byte[] salt;
    protected int saltPosition;
    protected int digestCount;

    public Digester(String algorithm) {
        this(algorithm, null);
    }

    public Digester(String algorithm, Provider provider) {
        this.init(algorithm, provider);
    }

    public Digester init(String algorithm, Provider provider) {
        if (null == provider) {
            this.digest = SecureUtil.createMessageDigest(algorithm);
        } else {
            try {
                this.digest = MessageDigest.getInstance(algorithm, provider);
            }
            catch (NoSuchAlgorithmException e) {
                throw new CryptoException((Throwable)e);
            }
        }
        return this;
    }

    public Digester setSalt(byte[] salt) {
        this.salt = salt;
        return this;
    }

    public Digester setDigestCount(int digestCount) {
        this.digestCount = digestCount;
        return this;
    }

    public Digester reset() {
        this.digest.reset();
        return this;
    }

    public byte[] digest(String data, String charsetName) {
        return this.digest(data, CryptoUtils.charset((String)charsetName));
    }

    public byte[] digest(String data, Charset charset) {
        return this.digest(CryptoUtils.bytes((CharSequence)data, (Charset)charset));
    }

    public byte[] digest(String data) {
        return this.digest(data, "UTF-8");
    }

    public String digestHex(String data, String charsetName) {
        return this.digestHex(data, CryptoUtils.charset((String)charsetName));
    }

    public String digestHex(String data, Charset charset) {
        return CryptoUtils.encodeHexStr((byte[])this.digest(data, charset));
    }

    public String digestHex(String data) {
        return this.digestHex(data, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] digest(File file) throws CryptoException, FileNotFoundException {
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(file));
            byte[] byArray = this.digest(in);
            return byArray;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public String digestHex(File file) throws FileNotFoundException {
        return CryptoUtils.encodeHexStr((byte[])this.digest(file));
    }

    public byte[] digest(byte[] data) {
        byte[] result;
        if (this.saltPosition <= 0) {
            result = this.doDigest(this.salt, data);
        } else if (this.saltPosition >= data.length) {
            result = this.doDigest(data, this.salt);
        } else if (this.salt != null && this.salt.length > 0) {
            this.digest.update(data, 0, this.saltPosition);
            this.digest.update(this.salt);
            this.digest.update(data, this.saltPosition, data.length - this.saltPosition);
            result = this.digest.digest();
        } else {
            result = this.doDigest(new byte[][]{data});
        }
        return this.resetAndRepeatDigest(result);
    }

    public byte[] digest(InputStream data) {
        return this.digest(data, this.DEFAULT_BUFFER_SIZE);
    }

    public String digestHex(InputStream data) {
        return CryptoUtils.encodeHexStr((byte[])this.digest(data));
    }

    public byte[] digest(InputStream data, int bufferLength) throws RuntimeException {
        byte[] result;
        if (bufferLength < 1) {
            bufferLength = this.DEFAULT_BUFFER_SIZE;
        }
        try {
            result = this.salt != null && this.salt.length > 0 ? this.digestWithoutSalt(data, bufferLength) : this.digestWithSalt(data, bufferLength);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.resetAndRepeatDigest(result);
    }

    public MessageDigest getDigest() {
        return this.digest;
    }

    public int getDigestLength() {
        return this.digest.getDigestLength();
    }

    private byte[] digestWithoutSalt(InputStream data, int bufferLength) throws IOException {
        int read;
        byte[] buffer = new byte[bufferLength];
        while ((read = data.read(buffer, 0, bufferLength)) > -1) {
            this.digest.update(buffer, 0, read);
        }
        return this.digest.digest();
    }

    private byte[] digestWithSalt(InputStream data, int bufferLength) throws IOException {
        int read;
        if (this.saltPosition <= 0) {
            this.digest.update(this.salt);
        }
        byte[] buffer = new byte[bufferLength];
        int total = 0;
        while ((read = data.read(buffer, 0, bufferLength)) > -1) {
            if (this.saltPosition > 0 && (total += read) >= this.saltPosition) {
                if (total != this.saltPosition) {
                    this.digest.update(buffer, 0, total - this.saltPosition);
                }
                this.digest.update(this.salt);
                this.digest.update(buffer, total - this.saltPosition, read);
                continue;
            }
            this.digest.update(buffer, 0, read);
        }
        if (total < this.saltPosition) {
            this.digest.update(this.salt);
        }
        return this.digest.digest();
    }

    private byte[] doDigest(byte[] ... datas) {
        for (byte[] data : datas) {
            if (null == data) continue;
            this.digest.update(data);
        }
        return this.digest.digest();
    }

    private byte[] resetAndRepeatDigest(byte[] digestData) {
        int digestCount = Math.max(1, this.digestCount);
        this.reset();
        for (int i = 0; i < digestCount - 1; ++i) {
            digestData = this.doDigest(new byte[][]{digestData});
            this.reset();
        }
        return digestData;
    }
}

