package com.upay.sdk.transferSingle;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.entity.TransferDomesticPayee;
import com.upay.sdk.exception.HmacVerifyException;
import com.upay.sdk.exception.RequestException;
import com.upay.sdk.exception.ResponseException;
import com.upay.sdk.exception.UnknownException;
import com.upay.sdk.executer.ResultListenerAdpater;
import com.upay.sdk.transferDomestic.builder.SingleOrderBuilder;
import com.upay.sdk.transferDomestic.executer.TransferDomesticSingleOrderExecuter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;

public class SingleOrderServlet extends HttpServlet {
	
    private static final long serialVersionUID = 3198435873337648370L;
    
    static final Logger LOGGER = LoggerFactory.getLogger(SingleOrderServlet.class);

	@Override
	protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
		doPost(req, resp);
	}

	@Override
	protected void doPost(HttpServletRequest req, final HttpServletResponse resp) throws ServletException, IOException {

	    
		req.setCharacterEncoding("UTF-8");
		String merchantId = req.getParameter("merchantId");
		String requestId = req.getParameter("requestId");
		String partnerId = req.getParameter("partnerId");
		String amount = req.getParameter("amount");
		String currency = req.getParameter("currency");
		String notifyUrl = req.getParameter("notifyUrl");
		String remark = req.getParameter("remark");
		
		//收款人
		String name = req.getParameter("name");
		String bankCardNum = req.getParameter("bankCardNum");
		String bankName = req.getParameter("bankName");
		String branchBankName = req.getParameter("branchBankName");

		
		SingleOrderBuilder builder = new SingleOrderBuilder(merchantId);
		builder.setAmount(amount).setCurrency(currency).setRequestId(requestId).setNotifyUrl(notifyUrl).setRemark(remark);
		builder.setPartnerId(partnerId);
		TransferDomesticPayee payee = new TransferDomesticPayee();
		payee.setName(name);
		payee.setBankCardNum(bankCardNum);
		payee.setBankName(bankName);
		payee.setBranchBankName(branchBankName);

		
		builder.setPayee(payee);
		
		final PrintWriter out = resp.getWriter();

		TransferDomesticSingleOrderExecuter executer = new TransferDomesticSingleOrderExecuter();
		try{
			executer.bothOrder(builder,new ResultListenerAdpater(){
				/**
				 * 提交并支付成功,不代表转账成功
				 */
			    @Override
				public void success(JSONObject jsonObject) {
					out.println("提交成功</br>");
					out.println(jsonObject);
				}
				
			});
		}
		catch(ResponseException e){
			out.println("响应异常</br>");
			out.println(e.toString());
		}
		catch(HmacVerifyException e){
			out.println("签名验证异常</br>");
			out.println(e.toString());
		}
		catch(RequestException e){
			out.println("请求异常</br>");
			out.println(e.toString());
		}
		catch(UnknownException e){
			out.println("未知异常</br>");
			out.println(e.toString());
		}
	}
}
